/*
 * Decompiled with CFR 0.152.
 */
package eu.dicodeproject.analysis.generic;

import eu.dicodeproject.analysis.generic.GenericMapper;
import eu.dicodeproject.analysis.generic.GenericReducer;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.cli2.Option;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.ValueFilter;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.commandline.DefaultOptionCreator;

public final class GenericDriver
extends AbstractJob {
    private static final String NONE = "none";

    private GenericDriver() {
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new GenericDriver(), (String[])args);
    }

    public int run(String[] args) throws ClassNotFoundException, InterruptedException, IOException {
        this.addOutputOption();
        this.addOption((Option)DefaultOptionCreator.numReducersOption().create());
        this.addOption("table", "t", "The hbase table holding our data.", "thtweets");
        this.addOption("family", "f", "The column family holding our data.", "d");
        this.addOption("column", "c", "The column holding our data.", "lang");
        this.addOption("separator", "s", "Separator used for splitting in column", NONE);
        this.addOption("query", "q", "The query, a simple string representing the topic.", "");
        this.addOption("daysBack", "d", "Number of Days - starting from last midnight - we want to scan", "1");
        Map argMap = this.parseArguments(args);
        if (argMap == null) {
            return -1;
        }
        String table = (String)argMap.get("--table");
        String family = (String)argMap.get("--family");
        String column = (String)argMap.get("--column");
        String separator = (String)argMap.get("--separator");
        String query = (String)argMap.get("--query");
        String daysBack = (String)argMap.get("--daysBack");
        Path output = this.getOutputPath();
        Configuration conf = HBaseConfiguration.create();
        if (separator != NONE) {
            conf.set("separator", (String)argMap.get("--separator"));
        }
        Job job = new Job(conf);
        job.setJarByClass(GenericDriver.class);
        Scan scan = new Scan();
        scan.addColumn(Bytes.toBytes((String)family), Bytes.toBytes((String)column));
        if (query != null && !query.equals("")) {
            scan.setFilter((Filter)new ValueFilter(CompareFilter.CompareOp.EQUAL, (WritableByteArrayComparable)new RegexStringComparator(query)));
        }
        if (daysBack != null && !daysBack.equals("")) {
            try {
                Calendar cal = this.getEndOfTimeRange();
                long maxStamp = cal.getTimeInMillis();
                int days = Integer.parseInt(daysBack);
                cal.add(5, days * -1);
                long minStamp = cal.getTimeInMillis();
                scan.setTimeRange(minStamp, maxStamp);
            }
            catch (NumberFormatException e) {
                System.out.println("Error: " + e.getMessage());
            }
        }
        TableMapReduceUtil.initTableMapperJob((String)table, (Scan)scan, GenericMapper.class, Text.class, IntWritable.class, (Job)job);
        job.setJobName("GenericCounter::" + column);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(IntWritable.class);
        job.setReducerClass(GenericReducer.class);
        job.setOutputKeyClass(IntWritable.class);
        job.setOutputValueClass(Text.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)output);
        job.setNumReduceTasks(1);
        job.waitForCompletion(true);
        return 0;
    }

    private Calendar getEndOfTimeRange() {
        Date d = new Date();
        Calendar cal = Calendar.getInstance(Locale.GERMANY);
        cal.setTime(d);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }
}

