/*
 * Decompiled with CFR 0.152.
 */
package eu.dicodeproject.analysis.export;

import eu.dicodeproject.analysis.export.TwitterExportMapper;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.cli2.Option;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.ValueFilter;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.commandline.DefaultOptionCreator;

public final class TwitterExportDriver
extends AbstractJob {
    private TwitterExportDriver() {
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new TwitterExportDriver(), (String[])args);
    }

    public int run(String[] args) throws IOException, ClassNotFoundException, InterruptedException {
        this.addOutputOption();
        this.addOption((Option)DefaultOptionCreator.numReducersOption().create());
        this.addOption("table", "t", "The hbase table holding our data.", "twittertracker");
        this.addOption("family", "f", "The column family holding our data.", "textFamily");
        this.addOption("column", "c", "The column holding our data.", "text");
        this.addOption("query", "q", "The query, a simple string representing the topic.", "Dicode");
        Map argMap = this.parseArguments(args);
        if (argMap == null) {
            return -1;
        }
        String table = (String)argMap.get("--table");
        String family = (String)argMap.get("--family");
        String column = (String)argMap.get("--column");
        String query = (String)argMap.get("--query");
        Path output = this.getOutputPath();
        Configuration conf = HBaseConfiguration.create();
        Job job = new Job(conf);
        job.setJarByClass(TwitterExportDriver.class);
        Scan scan = new Scan();
        scan.addColumn(Bytes.toBytes((String)family), Bytes.toBytes((String)column));
        scan.setFilter((Filter)new ValueFilter(CompareFilter.CompareOp.EQUAL, (WritableByteArrayComparable)new RegexStringComparator(query)));
        TableMapReduceUtil.initTableMapperJob((String)table, (Scan)scan, TwitterExportMapper.class, Text.class, Text.class, (Job)job);
        job.setJobName("TwitterExport");
        job.setReducerClass(Reducer.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)output);
        job.setNumReduceTasks(1);
        job.waitForCompletion(true);
        return 0;
    }
}

