/*
 * Decompiled with CFR 0.152.
 */
package eu.dicodeproject.analysis.examples;

import eu.dicodeproject.analysis.examples.MailContentHandler;
import eu.dicodeproject.analysis.examples.MailHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.mahout.text.ChunkedWriter;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.mbox.MboxParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MailArchiveToSequenceFile
implements PathFilter {
    private final String prefix;
    private final ChunkedWriter writer;
    private final Charset charset;
    private final MailContentHandler handler;
    private final FileSystem fs;
    private final Configuration conf;

    public MailArchiveToSequenceFile(Configuration conf, String prefix, ChunkedWriter writer, Charset charset) throws IOException {
        this(conf, prefix, writer, charset, new MailHandler(writer));
    }

    public MailArchiveToSequenceFile(Configuration conf, String prefix, ChunkedWriter writer, Charset charset, MailContentHandler handler) throws IOException {
        this.prefix = prefix;
        this.writer = writer;
        this.charset = charset;
        this.handler = handler;
        this.fs = FileSystem.get((Configuration)conf);
        this.conf = conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean accept(Path current) {
        try {
            FileStatus[] fstatus;
            for (FileStatus fst : fstatus = this.fs.listStatus(current)) {
                if (fst.isDir()) {
                    this.fs.listStatus(fst.getPath(), (PathFilter)new MailArchiveToSequenceFile(this.conf, this.prefix + File.separator + current.getName(), this.writer, this.charset));
                    continue;
                }
                InputStream stream = null;
                try {
                    MboxParser parser = new MboxParser();
                    Metadata meta = new Metadata();
                    stream = this.fs.open(fst.getPath());
                    this.handler.setPrefix(this.prefix + current.getName());
                    parser.parse(stream, (ContentHandler)this.handler, meta);
                }
                catch (FileNotFoundException e) {
                }
                catch (IOException e) {
                }
                catch (TikaException e) {
                }
                catch (SAXException e) {
                }
                finally {
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (Exception e) {}
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return false;
    }
}

