/**
 * Copyright (C) 2010, 2011 Neofonie GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package eu.dicodeproject.analysis.wordcount;

import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.mapreduce.TableReducer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

import java.io.IOException;

/**
 * Write word counts to a table, The date is the row ID, the column qualifier is the word.
 */
public class WordCountReducer extends TableReducer<Text, IntWritable, Text> {

  private String dateWordSeparator = "_";

  private String family = "d";

  private Text text = new Text();

  @Override
  public void reduce(Text keyin, Iterable<IntWritable> values, Context context) throws IOException, InterruptedException {

    // aggregate counts
    int wordCount = 0;
    for (IntWritable val : values) {
      wordCount += val.get();
    }

    // split key in date and word
    String[] elements = keyin.toString().split(dateWordSeparator, 2);
    String date = elements[0];
    String word = elements[1];

    // put date in table
    Put put = new Put(Bytes.toBytes(date));
    put.add(Bytes.toBytes(family), Bytes.toBytes(word), Bytes.toBytes( String.valueOf(wordCount) ));
    text.set(date);
    context.write(text, put);
  }
}
