/**
 * Copyright (C) 2010, 2011 Neofonie GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package eu.dicodeproject.analysis.lucene;

import java.io.Reader;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.util.Version;

/**
 * This class wraps the Lucene StandardAnalyzer - ties it to Lucene version
 * 3.0.2 and provides a constructor w/o any arguments for instantiation in the
 * Mahout collocation analysis.
 */
public final class StandardAnalyzerWrapper extends Analyzer {
  /** Delegate to StandardAnalyzer. */
  private final Analyzer analyzer = new StandardAnalyzer(Version.LUCENE_30);

  @Override
  public TokenStream tokenStream(String fieldName, Reader reader) {
    return this.analyzer.tokenStream(fieldName, reader);
  }
}
