#!/bin/bash
#
# Copyright (C) 2010, 2011 Neofonie GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#MAIN_CLASS=eu.dicodeproject.twitterstream.Debug
MAIN_CLASS=eu.dicodeproject.twitterstream.TwitterStream

MY_JAVA_OPTS="-Xmx1024m -server"

# log4j configuration file relative to classpath
LOG4J_CONF=eu.dicodeproject.twitterharvester.log4j.properties

if [ ! -n ${JAVA_HOME} ] 
then
	# works for sun java...
  export JAVA_HOME=`java -verbose | grep java\.lang\.Object | sed 's/.* \(.*\)lib\/rt\.jar\]/\1/'`
fi

PATH_TO_THIS_SCRIPT=`readlink -f $0`
PATH_TO_THIS_DIR=`dirname ${PATH_TO_THIS_SCRIPT}`
TH_PIDFILE=${PATH_TO_THIS_DIR}/pid/twitterharvester.pid


case "$1" in
  start)
    #create log directory
    mkdir -p ${PATH_TO_THIS_DIR}/log/
    mkdir -p ${PATH_TO_THIS_DIR}/pid/
    
    # classpath
    MY_CLASSPATH=${PATH_TO_THIS_DIR}/conf/    
    for jarFile in ${PATH_TO_THIS_DIR}/lib/*.jar ; do
      MY_CLASSPATH=${MY_CLASSPATH}:$jarFile
    done

    OLD_PATH=`pwd`
    cd ${PATH_TO_THIS_DIR}

    java ${MY_JAVA_OPTS} -Dlog4j.configuration=${LOG4J_CONF} -cp ${MY_CLASSPATH} ${MAIN_CLASS} &
    
    echo $! > ${TH_PIDFILE}

    cd ${OLD_PATH}

    ;;

  stop)
    MY_PID=`cat  ${TH_PIDFILE} `
      if [ ! $(ps -A | grep -q ${MY_PID}) ]
      then
        kill -9 ${MY_PID}
      fi
    rm ${TH_PIDFILE}  
    
  ;;
    
  *)
    echo "Usage: $0 {start|stop}" >&2
    exit 7
    ;;
    
esac 
