/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.http.alternative;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import twitter4j.TwitterException;
import twitter4j.internal.http.HttpClient;
import twitter4j.internal.http.HttpClientConfiguration;
import twitter4j.internal.http.HttpParameter;
import twitter4j.internal.http.HttpRequest;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.http.RequestMethod;
import twitter4j.internal.http.alternative.ApacheHttpClientHttpResponseImpl;
import twitter4j.internal.logging.Logger;
import twitter4j.internal.util.z_T4JInternalStringUtil;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClientImpl
implements HttpClient {
    private static final Logger logger = Logger.getLogger((Class)(class$twitter4j$internal$http$alternative$HttpClientImpl == null ? (class$twitter4j$internal$http$alternative$HttpClientImpl = HttpClientImpl.class$("twitter4j.internal.http.alternative.HttpClientImpl")) : class$twitter4j$internal$http$alternative$HttpClientImpl));
    private final HttpClientConfiguration conf;
    private final org.apache.http.client.HttpClient client;
    static /* synthetic */ Class class$twitter4j$internal$http$alternative$HttpClientImpl;

    public HttpClientImpl(HttpClientConfiguration conf) {
        this.conf = conf;
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        schemeRegistry.register(new Scheme("https", 443, (SchemeSocketFactory)SSLSocketFactory.getSocketFactory()));
        ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager(schemeRegistry);
        cm.setMaxTotal(conf.getHttpMaxTotalConnections());
        cm.setDefaultMaxPerRoute(conf.getHttpDefaultMaxPerRoute());
        DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)cm);
        HttpParams params = client.getParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)conf.getHttpConnectionTimeout());
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)conf.getHttpReadTimeout());
        if (conf.getHttpProxyHost() != null && !conf.getHttpProxyHost().equals("")) {
            HttpHost proxy = new HttpHost(conf.getHttpProxyHost(), conf.getHttpProxyPort());
            client.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            if (conf.getHttpProxyUser() != null && !conf.getHttpProxyUser().equals("")) {
                if (logger.isDebugEnabled()) {
                    logger.debug(new StringBuffer().append("Proxy AuthUser: ").append(conf.getHttpProxyUser()).toString());
                    logger.debug(new StringBuffer().append("Proxy AuthPassword: ").append(z_T4JInternalStringUtil.maskString((String)conf.getHttpProxyPassword())).toString());
                }
                client.getCredentialsProvider().setCredentials(new AuthScope(conf.getHttpProxyHost(), conf.getHttpProxyPort()), (Credentials)new UsernamePasswordCredentials(conf.getHttpProxyUser(), conf.getHttpProxyPassword()));
            }
        }
        this.client = client;
    }

    public void shutdown() {
        this.client.getConnectionManager().shutdown();
    }

    public HttpResponse request(HttpRequest req) throws TwitterException {
        try {
            ApacheHttpClientHttpResponseImpl res;
            String authorizationHeader;
            HttpGet commonsRequest;
            if (req.getMethod() == RequestMethod.GET) {
                commonsRequest = new HttpGet(this.composeURL(req));
            } else if (req.getMethod() == RequestMethod.POST) {
                HttpPost post = new HttpPost(req.getURL());
                boolean hasFile = false;
                if (req.getParameters() != null) {
                    for (HttpParameter parameter : req.getParameters()) {
                        if (!parameter.isFile()) continue;
                        hasFile = true;
                        break;
                    }
                    if (!hasFile) {
                        List<NameValuePair> nameValuePair = this.asNameValuePairList(req);
                        if (nameValuePair != null) {
                            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(nameValuePair, "UTF-8");
                            post.setEntity((HttpEntity)entity);
                        }
                    } else {
                        MultipartEntity me = new MultipartEntity();
                        for (HttpParameter parameter : req.getParameters()) {
                            if (parameter.isFile()) {
                                me.addPart(parameter.getName(), (ContentBody)new FileBody(parameter.getFile(), parameter.getContentType()));
                                continue;
                            }
                            me.addPart(parameter.getName(), (ContentBody)new StringBody(parameter.getValue()));
                        }
                        post.setEntity((HttpEntity)me);
                    }
                }
                post.getParams().setBooleanParameter("http.protocol.expect-continue", false);
                commonsRequest = post;
            } else if (req.getMethod() == RequestMethod.DELETE) {
                commonsRequest = new HttpDelete(this.composeURL(req));
            } else if (req.getMethod() == RequestMethod.HEAD) {
                commonsRequest = new HttpHead(this.composeURL(req));
            } else if (req.getMethod() == RequestMethod.PUT) {
                commonsRequest = new HttpPut(this.composeURL(req));
            } else {
                throw new AssertionError();
            }
            Map headers = req.getRequestHeaders();
            for (String headerName : headers.keySet()) {
                commonsRequest.addHeader(headerName, (String)headers.get(headerName));
            }
            if (req.getAuthorization() != null && (authorizationHeader = req.getAuthorization().getAuthorizationHeader(req)) != null) {
                commonsRequest.addHeader("Authorization", authorizationHeader);
            }
            if (200 != (res = new ApacheHttpClientHttpResponseImpl(this.client.execute((HttpUriRequest)commonsRequest), this.conf)).getStatusCode()) {
                throw new TwitterException(res.asString(), (HttpResponse)res);
            }
            return res;
        }
        catch (IOException e) {
            throw new TwitterException((Exception)e);
        }
    }

    private String composeURL(HttpRequest req) {
        List<NameValuePair> params = this.asNameValuePairList(req);
        if (params != null) {
            return new StringBuffer().append(req.getURL()).append("?").append(URLEncodedUtils.format(params, (String)"UTF-8")).toString();
        }
        return req.getURL();
    }

    private List<NameValuePair> asNameValuePairList(HttpRequest req) {
        if (req.getParameters() != null && req.getParameters().length > 0) {
            ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
            for (HttpParameter parameter : req.getParameters()) {
                params.add((NameValuePair)new BasicNameValuePair(parameter.getName(), parameter.getValue()));
            }
            return params;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

