/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.http.alternative;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import twitter4j.internal.http.HttpClientConfiguration;
import twitter4j.internal.http.HttpResponse;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ApacheHttpClientHttpResponseImpl
extends HttpResponse {
    private org.apache.http.HttpResponse res;

    ApacheHttpClientHttpResponseImpl(org.apache.http.HttpResponse res, HttpClientConfiguration conf) throws IOException {
        super(conf);
        this.res = res;
        this.is = res.getEntity().getContent();
        this.statusCode = res.getStatusLine().getStatusCode();
        if (this.is != null && "gzip".equals(this.getResponseHeader("Content-Encoding"))) {
            this.is = new GZIPInputStream(this.is);
        }
    }

    public final String getResponseHeader(String name) {
        Header[] headers = this.res.getHeaders(name);
        if (headers != null && headers.length > 0) {
            return headers[0].getValue();
        }
        return null;
    }

    public Map<String, List<String>> getResponseHeaderFields() {
        Header[] headers = this.res.getAllHeaders();
        HashMap<String, List<String>> maps = new HashMap<String, List<String>>();
        for (Header header : headers) {
            HeaderElement[] elements;
            for (HeaderElement element : elements = header.getElements()) {
                ArrayList<String> values = (ArrayList<String>)maps.get(element.getName());
                if (null == values) {
                    values = new ArrayList<String>(1);
                    maps.put(element.getName(), values);
                }
                values.add(element.getValue());
            }
        }
        return maps;
    }

    public void disconnect() throws IOException {
        if (this.res != null) {
            this.res.getEntity().consumeContent();
        }
    }
}

