/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.ga.watchmaker.travellingsalesman;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import javax.swing.JApplet;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.mahout.ga.watchmaker.travellingsalesman.EuropeanDistanceLookup;
import org.apache.mahout.ga.watchmaker.travellingsalesman.ExecutionPanel;
import org.apache.mahout.ga.watchmaker.travellingsalesman.ItineraryPanel;
import org.apache.mahout.ga.watchmaker.travellingsalesman.RouteEvaluator;
import org.apache.mahout.ga.watchmaker.travellingsalesman.StrategyPanel;
import org.apache.mahout.ga.watchmaker.travellingsalesman.TravellingSalesmanStrategy;
import org.uncommons.swing.SwingBackgroundTask;
import org.uncommons.watchmaker.framework.FitnessEvaluator;

public final class TravellingSalesman
extends JApplet {
    private final ItineraryPanel itineraryPanel;
    private final StrategyPanel strategyPanel;
    private final ExecutionPanel executionPanel;
    private final FitnessEvaluator<List<String>> evaluator;

    public TravellingSalesman() {
        EuropeanDistanceLookup distances = new EuropeanDistanceLookup();
        this.evaluator = new RouteEvaluator(distances);
        this.itineraryPanel = new ItineraryPanel(distances.getKnownCities());
        this.strategyPanel = new StrategyPanel(distances);
        this.executionPanel = new ExecutionPanel();
        this.add((Component)this.itineraryPanel, "West");
        JPanel innerPanel = new JPanel(new BorderLayout());
        innerPanel.add((Component)this.strategyPanel, "North");
        innerPanel.add((Component)this.executionPanel, "Center");
        this.add((Component)innerPanel, "Center");
        this.executionPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Collection<String> cities = TravellingSalesman.this.itineraryPanel.getSelectedCities();
                if (cities.size() < 4) {
                    JOptionPane.showMessageDialog(TravellingSalesman.this, "Itinerary must include at least 4 cities.", "Error", 0);
                } else {
                    try {
                        TravellingSalesman.this.setEnabled(false);
                        TravellingSalesman.this.createTask(cities).execute();
                    }
                    catch (IllegalArgumentException ex) {
                        JOptionPane.showMessageDialog(TravellingSalesman.this, ex.getMessage(), "Error", 0);
                        TravellingSalesman.this.setEnabled(true);
                    }
                }
            }
        });
        this.validate();
    }

    private SwingBackgroundTask<List<String>> createTask(Collection<String> cities) {
        TravellingSalesmanStrategy strategy = this.strategyPanel.getStrategy();
        return new TSSwingBackgroundTask(strategy, cities, this.executionPanel, this.evaluator);
    }

    @Override
    public void setEnabled(boolean b) {
        this.itineraryPanel.setEnabled(b);
        this.strategyPanel.setEnabled(b);
        this.executionPanel.setEnabled(b);
        super.setEnabled(b);
    }

    public static void main(String[] args) {
        JDialog dialog = new JDialog((Frame)null, "Travelling Salesman Frame", true);
        dialog.setDefaultCloseOperation(2);
        dialog.getContentPane().add(new TravellingSalesman());
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
    }

    private final class TSSwingBackgroundTask
    extends SwingBackgroundTask<List<String>> {
        private long elapsedTime;
        private final TravellingSalesmanStrategy strategy;
        private final Collection<String> cities;
        private final ExecutionPanel executionPanel;
        private final FitnessEvaluator<List<String>> evaluator;

        private TSSwingBackgroundTask(TravellingSalesmanStrategy strategy, Collection<String> cities, ExecutionPanel executionPanel, FitnessEvaluator<List<String>> evaluator) {
            this.strategy = strategy;
            this.cities = cities;
            this.executionPanel = executionPanel;
            this.evaluator = evaluator;
        }

        protected List<String> performTask() {
            long startTime = System.currentTimeMillis();
            List<String> result = this.strategy.calculateShortestRoute(this.cities, this.executionPanel);
            this.elapsedTime = System.currentTimeMillis() - startTime;
            return result;
        }

        protected void postProcessing(List<String> result) {
            this.executionPanel.appendOutput(this.createResultString(this.strategy.getDescription(), result, this.evaluator.getFitness(result, null), this.elapsedTime));
            TravellingSalesman.this.setEnabled(true);
        }

        private String createResultString(String strategyDescription, List<String> shortestRoute, double distance, long elapsedTime) {
            StringBuilder buffer = new StringBuilder(100);
            buffer.append('[');
            buffer.append(strategyDescription);
            buffer.append("]\n");
            buffer.append("ROUTE: ");
            for (String s : shortestRoute) {
                buffer.append(s);
                buffer.append(" -> ");
            }
            buffer.append(shortestRoute.get(0));
            buffer.append('\n');
            buffer.append("TOTAL DISTANCE: ");
            buffer.append(String.valueOf(distance));
            buffer.append("km\n");
            buffer.append("(Search Time: ");
            double seconds = (double)elapsedTime / 1000.0;
            buffer.append(String.valueOf(seconds));
            buffer.append(" seconds)\n\n");
            return buffer.toString();
        }
    }
}

