/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.ga.watchmaker.travellingsalesman;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import org.apache.mahout.ga.watchmaker.travellingsalesman.BruteForceTravellingSalesman;
import org.apache.mahout.ga.watchmaker.travellingsalesman.DistanceLookup;
import org.apache.mahout.ga.watchmaker.travellingsalesman.EvolutionaryTravellingSalesman;
import org.apache.mahout.ga.watchmaker.travellingsalesman.TravellingSalesmanStrategy;
import org.uncommons.maths.random.Probability;
import org.uncommons.swing.SpringUtilities;
import org.uncommons.watchmaker.framework.SelectionStrategy;
import org.uncommons.watchmaker.framework.selection.RankSelection;
import org.uncommons.watchmaker.framework.selection.RouletteWheelSelection;
import org.uncommons.watchmaker.framework.selection.StochasticUniversalSampling;
import org.uncommons.watchmaker.framework.selection.TournamentSelection;
import org.uncommons.watchmaker.framework.selection.TruncationSelection;

final class StrategyPanel
extends JPanel {
    private final DistanceLookup distances;
    private final JRadioButton evolutionOption;
    private final JRadioButton bruteForceOption;
    private final EvolutionPanel evolutionPanel;

    StrategyPanel(DistanceLookup distances) {
        super(new BorderLayout());
        this.distances = distances;
        this.evolutionOption = new JRadioButton("Evolution", true);
        this.bruteForceOption = new JRadioButton("Brute Force", false);
        this.evolutionOption.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                StrategyPanel.this.evolutionPanel.setEnabled(StrategyPanel.this.evolutionOption.isSelected());
            }
        });
        ButtonGroup strategyGroup = new ButtonGroup();
        strategyGroup.add(this.evolutionOption);
        strategyGroup.add(this.bruteForceOption);
        this.evolutionPanel = new EvolutionPanel();
        this.add((Component)this.evolutionOption, "North");
        this.add((Component)this.evolutionPanel, "Center");
        this.add((Component)this.bruteForceOption, "South");
        this.setBorder(BorderFactory.createTitledBorder("Route-Finding Strategy"));
    }

    public TravellingSalesmanStrategy getStrategy() {
        return this.bruteForceOption.isSelected() ? new BruteForceTravellingSalesman(this.distances) : this.evolutionPanel.getStrategy();
    }

    @Override
    public void setEnabled(boolean b) {
        this.evolutionOption.setEnabled(b);
        this.bruteForceOption.setEnabled(b);
        this.evolutionPanel.setEnabled(b && this.evolutionOption.isSelected());
        super.setEnabled(b);
    }

    private final class EvolutionPanel
    extends JPanel {
        private final JLabel populationLabel;
        private final JSpinner populationSpinner;
        private final JLabel elitismLabel;
        private final JSpinner elitismSpinner;
        private final JLabel generationsLabel;
        private final JSpinner generationsSpinner;
        private final JLabel selectionLabel;
        private final JComboBox selectionCombo;
        private final JCheckBox crossoverCheckbox;
        private final JCheckBox mutationCheckbox;
        private final JCheckBox distributedCheckbox;

        EvolutionPanel() {
            super(new FlowLayout(0, 0, 0));
            JPanel innerPanel = new JPanel(new SpringLayout());
            this.populationLabel = new JLabel("Population Size: ");
            this.populationSpinner = new JSpinner(new SpinnerNumberModel(300, 2, 10000, 1));
            this.populationLabel.setLabelFor(this.populationSpinner);
            innerPanel.add(this.populationLabel);
            innerPanel.add(this.populationSpinner);
            this.elitismLabel = new JLabel("Elitism: ");
            this.elitismSpinner = new JSpinner(new SpinnerNumberModel(3, 0, 10000, 1));
            this.elitismLabel.setLabelFor(this.elitismSpinner);
            innerPanel.add(this.elitismLabel);
            innerPanel.add(this.elitismSpinner);
            this.generationsLabel = new JLabel("Number of Generations: ");
            this.generationsSpinner = new JSpinner(new SpinnerNumberModel(100, 1, 10000, 1));
            this.generationsLabel.setLabelFor(this.generationsSpinner);
            innerPanel.add(this.generationsLabel);
            innerPanel.add(this.generationsSpinner);
            this.selectionLabel = new JLabel("Selection Strategy: ");
            innerPanel.add(this.selectionLabel);
            SelectionStrategy[] selectionStrategies = new SelectionStrategy[]{new RankSelection(), new RouletteWheelSelection(), new StochasticUniversalSampling(), new TournamentSelection(new Probability(0.95)), new TruncationSelection(0.5)};
            this.selectionCombo = new JComboBox<SelectionStrategy>(selectionStrategies);
            this.selectionCombo.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
                    SelectionStrategy strategy = (SelectionStrategy)value;
                    String text = strategy.getClass().getSimpleName();
                    return super.getListCellRendererComponent((JList<?>)list, text, index, isSelected, hasFocus);
                }
            });
            this.selectionCombo.setSelectedIndex(this.selectionCombo.getItemCount() - 1);
            innerPanel.add(this.selectionCombo);
            this.crossoverCheckbox = new JCheckBox("Cross-over", true);
            this.mutationCheckbox = new JCheckBox("Mutation", true);
            this.distributedCheckbox = new JCheckBox("Distributed (Mahout)", false);
            innerPanel.add(this.crossoverCheckbox);
            innerPanel.add(this.mutationCheckbox);
            innerPanel.add(this.distributedCheckbox);
            innerPanel.add(new JLabel());
            SpringUtilities.makeCompactGrid((Container)innerPanel, (int)6, (int)2, (int)30, (int)6, (int)6, (int)6);
            this.add(innerPanel);
        }

        @Override
        public void setEnabled(boolean b) {
            this.populationLabel.setEnabled(b);
            this.populationSpinner.setEnabled(b);
            this.elitismLabel.setEnabled(b);
            this.elitismSpinner.setEnabled(b);
            this.generationsLabel.setEnabled(b);
            this.generationsSpinner.setEnabled(b);
            this.selectionLabel.setEnabled(b);
            this.selectionCombo.setEnabled(b);
            this.crossoverCheckbox.setEnabled(b);
            this.mutationCheckbox.setEnabled(b);
            this.distributedCheckbox.setEnabled(b);
            super.setEnabled(b);
        }

        public TravellingSalesmanStrategy getStrategy() {
            return new EvolutionaryTravellingSalesman(StrategyPanel.this.distances, (SelectionStrategy<? super List<String>>)((SelectionStrategy)this.selectionCombo.getSelectedItem()), (Integer)this.populationSpinner.getValue(), (Integer)this.elitismSpinner.getValue(), (Integer)this.generationsSpinner.getValue(), this.crossoverCheckbox.isSelected(), this.mutationCheckbox.isSelected(), this.distributedCheckbox.isSelected());
        }
    }
}

