/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.ga.watchmaker.travellingsalesman;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

final class ItineraryPanel
extends JPanel {
    private final Collection<JCheckBox> checkBoxes;
    private final JButton selectAllButton;
    private final JButton clearButton;

    ItineraryPanel(Collection<String> cities) {
        super(new BorderLayout());
        JPanel checkBoxPanel = new JPanel(new GridLayout(0, 1));
        this.checkBoxes = new ArrayList<JCheckBox>(cities.size());
        for (String city : cities) {
            JCheckBox checkBox = new JCheckBox(city, false);
            this.checkBoxes.add(checkBox);
            checkBoxPanel.add(checkBox);
        }
        this.add((Component)checkBoxPanel, "Center");
        JPanel buttonPanel = new JPanel(new GridLayout(2, 1));
        this.selectAllButton = new JButton("Select All");
        buttonPanel.add(this.selectAllButton);
        this.clearButton = new JButton("Clear Selection");
        buttonPanel.add(this.clearButton);
        ActionListener buttonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean select = actionEvent.getSource() == ItineraryPanel.this.selectAllButton;
                for (JCheckBox checkBox : ItineraryPanel.this.checkBoxes) {
                    checkBox.setSelected(select);
                }
            }
        };
        this.selectAllButton.addActionListener(buttonListener);
        this.clearButton.addActionListener(buttonListener);
        this.add((Component)buttonPanel, "South");
        this.setBorder(BorderFactory.createTitledBorder("Itinerary"));
    }

    public Collection<String> getSelectedCities() {
        TreeSet<String> cities = new TreeSet<String>();
        for (JCheckBox checkBox : this.checkBoxes) {
            if (!checkBox.isSelected()) continue;
            cities.add(checkBox.getText());
        }
        return cities;
    }

    @Override
    public void setEnabled(boolean b) {
        for (JCheckBox checkBox : this.checkBoxes) {
            checkBox.setEnabled(b);
        }
        this.selectAllButton.setEnabled(b);
        this.clearButton.setEnabled(b);
        super.setEnabled(b);
    }
}

