/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.ga.watchmaker.travellingsalesman;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.apache.mahout.ga.watchmaker.travellingsalesman.ProgressListener;

final class ExecutionPanel
extends JPanel
implements ProgressListener {
    private final JButton startButton;
    private final JTextArea output;
    private final JScrollPane scroller;
    private final JProgressBar progressBar;

    ExecutionPanel() {
        super(new BorderLayout());
        JPanel controlPanel = new JPanel(new BorderLayout());
        this.startButton = new JButton("Start");
        controlPanel.add((Component)this.startButton, "West");
        this.progressBar = new JProgressBar(0, 100);
        controlPanel.add((Component)this.progressBar, "Center");
        this.add((Component)controlPanel, "North");
        this.output = new JTextArea();
        this.output.setEditable(false);
        this.output.setLineWrap(true);
        this.output.setWrapStyleWord(true);
        this.output.setFont(new Font("Monospaced", 0, 12));
        this.scroller = new JScrollPane(this.output);
        this.scroller.setBorder(BorderFactory.createTitledBorder("Results"));
        this.add((Component)this.scroller, "Center");
    }

    public void addActionListener(ActionListener actionListener) {
        this.startButton.addActionListener(actionListener);
    }

    @Override
    public void updateProgress(final double percentComplete) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExecutionPanel.this.progressBar.setValue((int)percentComplete);
            }
        });
    }

    public void appendOutput(String text) {
        this.output.append(text);
    }

    @Override
    public void setEnabled(boolean b) {
        this.startButton.setEnabled(b);
        this.scroller.setEnabled(b);
        super.setEnabled(b);
    }
}

