/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.ga.watchmaker.travellingsalesman;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.ga.watchmaker.MahoutFitnessEvaluator;
import org.apache.mahout.ga.watchmaker.travellingsalesman.DistanceLookup;
import org.apache.mahout.ga.watchmaker.travellingsalesman.ProgressListener;
import org.apache.mahout.ga.watchmaker.travellingsalesman.RouteEvaluator;
import org.apache.mahout.ga.watchmaker.travellingsalesman.TravellingSalesmanStrategy;
import org.uncommons.maths.number.NumberGenerator;
import org.uncommons.maths.random.PoissonGenerator;
import org.uncommons.watchmaker.framework.CandidateFactory;
import org.uncommons.watchmaker.framework.ConcurrentEvolutionEngine;
import org.uncommons.watchmaker.framework.EvolutionEngine;
import org.uncommons.watchmaker.framework.EvolutionObserver;
import org.uncommons.watchmaker.framework.EvolutionaryOperator;
import org.uncommons.watchmaker.framework.FitnessEvaluator;
import org.uncommons.watchmaker.framework.PopulationData;
import org.uncommons.watchmaker.framework.SelectionStrategy;
import org.uncommons.watchmaker.framework.SequentialEvolutionEngine;
import org.uncommons.watchmaker.framework.TerminationCondition;
import org.uncommons.watchmaker.framework.factories.ListPermutationFactory;
import org.uncommons.watchmaker.framework.operators.EvolutionPipeline;
import org.uncommons.watchmaker.framework.operators.ListOrderCrossover;
import org.uncommons.watchmaker.framework.operators.ListOrderMutation;
import org.uncommons.watchmaker.framework.termination.GenerationCount;

public class EvolutionaryTravellingSalesman
implements TravellingSalesmanStrategy {
    private final DistanceLookup distances;
    private final SelectionStrategy<? super List<String>> selectionStrategy;
    private final int populationSize;
    private final int eliteCount;
    private final int generationCount;
    private final boolean crossover;
    private final boolean mutation;
    private final boolean mahout;

    public EvolutionaryTravellingSalesman(DistanceLookup distances, SelectionStrategy<? super List<String>> selectionStrategy, int populationSize, int eliteCount, int generationCount, boolean crossover, boolean mutation, boolean mahout) {
        Preconditions.checkArgument((eliteCount >= 0 && eliteCount < populationSize ? 1 : 0) != 0, (Object)"Elite count must be non-zero and less than population size.");
        Preconditions.checkArgument((crossover || mutation ? 1 : 0) != 0, (Object)"At least one of cross-over or mutation must be selected.");
        this.distances = distances;
        this.selectionStrategy = selectionStrategy;
        this.populationSize = populationSize;
        this.eliteCount = eliteCount;
        this.generationCount = generationCount;
        this.crossover = crossover;
        this.mutation = mutation;
        this.mahout = mahout;
    }

    @Override
    public String getDescription() {
        String selectionName = this.selectionStrategy.getClass().getSimpleName();
        return (this.mahout ? "Mahout " : "") + "Evolution (pop: " + this.populationSize + ", gen: " + this.generationCount + ", elite: " + this.eliteCount + ", " + selectionName + ')';
    }

    @Override
    public List<String> calculateShortestRoute(Collection<String> cities, final ProgressListener progressListener) {
        Random rng = RandomUtils.getRandom();
        ArrayList<Object> operators = new ArrayList<Object>(2);
        if (this.crossover) {
            operators.add(new ListOrderCrossover());
        }
        if (this.mutation) {
            operators.add(new ListOrderMutation((NumberGenerator)new PoissonGenerator(1.5, rng), (NumberGenerator)new PoissonGenerator(1.5, rng)));
        }
        EvolutionPipeline pipeline = new EvolutionPipeline(operators);
        ListPermutationFactory candidateFactory = new ListPermutationFactory(new LinkedList<String>(cities));
        EvolutionEngine<List<String>> engine = this.getEngine((CandidateFactory<List<String>>)candidateFactory, (EvolutionaryOperator<List<String>>)pipeline, rng);
        engine.addEvolutionObserver((EvolutionObserver)new EvolutionObserver<List<String>>(){

            public void populationUpdate(PopulationData<? extends List<String>> data) {
                if (progressListener != null) {
                    progressListener.updateProgress(((double)data.getGenerationNumber() + 1.0) / (double)EvolutionaryTravellingSalesman.this.generationCount * 100.0);
                }
            }
        });
        return (List)engine.evolve(this.populationSize, this.eliteCount, new TerminationCondition[]{new GenerationCount(this.generationCount)});
    }

    private EvolutionEngine<List<String>> getEngine(CandidateFactory<List<String>> candidateFactory, EvolutionaryOperator<List<String>> pipeline, Random rng) {
        if (this.mahout) {
            MahoutFitnessEvaluator evaluator = new MahoutFitnessEvaluator((FitnessEvaluator)new RouteEvaluator(this.distances));
            return new SequentialEvolutionEngine(candidateFactory, pipeline, (FitnessEvaluator)evaluator, this.selectionStrategy, rng);
        }
        return new ConcurrentEvolutionEngine(candidateFactory, pipeline, (FitnessEvaluator)new RouteEvaluator(this.distances), this.selectionStrategy, rng);
    }
}

