/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.ga.watchmaker.travellingsalesman;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.mahout.ga.watchmaker.travellingsalesman.DistanceLookup;
import org.apache.mahout.ga.watchmaker.travellingsalesman.ProgressListener;
import org.apache.mahout.ga.watchmaker.travellingsalesman.RouteEvaluator;
import org.apache.mahout.ga.watchmaker.travellingsalesman.TravellingSalesmanStrategy;
import org.uncommons.maths.combinatorics.PermutationGenerator;

public class BruteForceTravellingSalesman
implements TravellingSalesmanStrategy {
    private final DistanceLookup distances;

    public BruteForceTravellingSalesman(DistanceLookup distances) {
        this.distances = distances;
    }

    @Override
    public String getDescription() {
        return "Brute Force";
    }

    @Override
    public List<String> calculateShortestRoute(Collection<String> cities, ProgressListener progressListener) {
        Iterator<String> iterator = cities.iterator();
        String startCity = iterator.next();
        ArrayList<String> destinations = new ArrayList<String>(cities.size() - 1);
        while (iterator.hasNext()) {
            destinations.add(iterator.next());
        }
        RouteEvaluator evaluator = new RouteEvaluator(this.distances);
        PermutationGenerator generator = new PermutationGenerator(destinations);
        long totalPermutations = generator.getTotalPermutations();
        long count = 0L;
        ArrayList shortestRoute = null;
        double shortestDistance = Double.POSITIVE_INFINITY;
        ArrayList currentRoute = new ArrayList(cities.size());
        while (generator.hasMore()) {
            List route = generator.nextPermutationAsList(currentRoute);
            route.add(0, startCity);
            double distance = evaluator.getFitness(route, null);
            if (distance < shortestDistance) {
                shortestDistance = distance;
                shortestRoute = new ArrayList(route);
            }
            if (++count % 1000L != 0L || progressListener == null) continue;
            progressListener.updateProgress((double)count / (double)totalPermutations * 100.0);
        }
        if (progressListener != null) {
            progressListener.updateProgress(100.0);
        }
        return shortestRoute;
    }
}

