/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.ga.watchmaker.cd.tool;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.ga.watchmaker.cd.tool.DescriptionUtils;
import org.apache.mahout.ga.watchmaker.cd.tool.Descriptors;

public class ToolReducer
extends Reducer<LongWritable, Text, LongWritable, Text> {
    private Descriptors descriptors;
    private final Collection<String> distinct = new HashSet<String>();

    protected void reduce(LongWritable key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
        context.write((Object)key, (Object)new Text(this.combineDescriptions((int)key.get(), values.iterator())));
    }

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        String descriptors = context.getConfiguration().get("cdtool.attributes");
        if (descriptors != null) {
            this.configure(descriptors.toCharArray());
        }
    }

    void configure(char[] descriptors) {
        Preconditions.checkArgument((descriptors != null && descriptors.length > 0 ? 1 : 0) != 0, (Object)"descriptors null or empty");
        this.descriptors = new Descriptors(descriptors);
    }

    String combineDescriptions(int index, Iterator<Text> values) {
        if (this.descriptors.isNumerical(index)) {
            return ToolReducer.numericDescription(values);
        }
        if (this.descriptors.isNominal(index)) {
            return this.nominalDescription(values);
        }
        throw new IllegalArgumentException();
    }

    static String numericDescription(Iterator<Text> values) {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        while (values.hasNext()) {
            double[] range = DescriptionUtils.extractNumericalRange(values.next().toString());
            min = Math.min(min, range[0]);
            max = Math.max(max, range[1]);
        }
        return DescriptionUtils.createNumericalDescription(min, max);
    }

    String nominalDescription(Iterator<Text> values) {
        this.distinct.clear();
        while (values.hasNext()) {
            DescriptionUtils.extractNominalValues(values.next().toString(), this.distinct);
        }
        return DescriptionUtils.createNominalDescription(this.distinct);
    }
}

