/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.ga.watchmaker.cd.tool;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.ga.watchmaker.cd.tool.Descriptors;

public class ToolMapper
extends Mapper<LongWritable, Text, LongWritable, Text> {
    public static final String ATTRIBUTES = "cdtool.attributes";
    private static final Pattern COMMA = Pattern.compile(",");
    private Descriptors descriptors;

    protected void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        List<String> attributes = ToolMapper.extractAttributes(value);
        Preconditions.checkArgument((attributes.size() == this.descriptors.size() ? 1 : 0) != 0, (Object)"Attributes number should be equal to the descriptors's array length");
        for (int index = 0; index < attributes.size(); ++index) {
            if (this.descriptors.isIgnored(index)) continue;
            context.write((Object)new LongWritable((long)index), (Object)new Text(attributes.get(index)));
        }
    }

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        String descriptors = context.getConfiguration().get(ATTRIBUTES);
        if (descriptors != null) {
            this.configure(descriptors.toCharArray());
        }
    }

    void configure(char[] descriptors) {
        Preconditions.checkArgument((descriptors != null && descriptors.length > 0 ? 1 : 0) != 0, (Object)"descriptors null or empty");
        this.descriptors = new Descriptors(descriptors);
    }

    static List<String> extractAttributes(Text value) {
        ArrayList<String> result = new ArrayList<String>();
        for (String token : COMMA.split(value.toString())) {
            result.add(token.trim());
        }
        return result;
    }
}

