/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.ga.watchmaker.cd.tool;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.ga.watchmaker.cd.tool.DescriptionUtils;
import org.apache.mahout.ga.watchmaker.cd.tool.Descriptors;

public class ToolCombiner
extends Reducer<LongWritable, Text, LongWritable, Text> {
    private final Collection<String> distinct = new HashSet<String>();
    private Descriptors descriptors;

    protected void reduce(LongWritable key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
        context.write((Object)key, (Object)new Text(this.createDescription((int)key.get(), values.iterator())));
    }

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        String descriptors = context.getConfiguration().get("cdtool.attributes");
        if (descriptors != null) {
            this.configure(descriptors.toCharArray());
        }
    }

    void configure(char[] descriptors) {
        Preconditions.checkArgument((descriptors != null && descriptors.length > 0 ? 1 : 0) != 0, (Object)"descriptors null or empty");
        this.descriptors = new Descriptors(descriptors);
    }

    String createDescription(int index, Iterator<Text> values) {
        if (this.descriptors.isNominal(index)) {
            return this.nominalDescription(values);
        }
        if (this.descriptors.isNumerical(index)) {
            return ToolCombiner.numericalDescription(values);
        }
        throw new IllegalArgumentException("An ignored attribute should never reach the Combiner");
    }

    String nominalDescription(Iterator<Text> values) {
        this.distinct.clear();
        while (values.hasNext()) {
            this.distinct.add(values.next().toString());
        }
        return DescriptionUtils.createNominalDescription(this.distinct);
    }

    static String numericalDescription(Iterator<Text> values) {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        while (values.hasNext()) {
            double value = Double.parseDouble(values.next().toString());
            if (value < min) {
                min = value;
                continue;
            }
            if (!(value > max)) continue;
            max = value;
        }
        return DescriptionUtils.createNumericalDescription(min, max);
    }
}

