/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.ga.watchmaker.cd.tool;

import com.google.common.base.Preconditions;

public final class Descriptors {
    private final char[] descriptors;

    public Descriptors(char[] descriptors) {
        Preconditions.checkArgument((descriptors != null && descriptors.length > 0 ? 1 : 0) != 0, (Object)"descriptors null or empty");
        this.descriptors = descriptors;
        for (int index = 0; index < descriptors.length; ++index) {
            Preconditions.checkArgument((this.isIgnored(index) || this.isNumerical(index) || this.isNominal(index) ? 1 : 0) != 0, (String)"Bad descriptor value", (Object[])new Object[]{Character.valueOf(descriptors[index])});
        }
    }

    public boolean isIgnored(int index) {
        return this.descriptors[index] == 'i' || this.descriptors[index] == 'I';
    }

    public boolean isNumerical(int index) {
        return this.descriptors[index] == 'n' || this.descriptors[index] == 'N';
    }

    public boolean isNominal(int index) {
        return this.descriptors[index] == 'c' || this.descriptors[index] == 'C' || this.isLabel(index);
    }

    public boolean isLabel(int index) {
        return this.descriptors[index] == 'l' || this.descriptors[index] == 'L';
    }

    public int size() {
        return this.descriptors.length;
    }

    public char[] getChars() {
        return this.descriptors;
    }
}

