/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.ga.watchmaker.cd.tool;

import com.google.common.base.Preconditions;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.mahout.common.CommandLineUtil;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileValueIterable;
import org.apache.mahout.ga.watchmaker.OutputUtils;
import org.apache.mahout.ga.watchmaker.cd.FileInfoParser;
import org.apache.mahout.ga.watchmaker.cd.tool.Descriptors;
import org.apache.mahout.ga.watchmaker.cd.tool.ToolCombiner;
import org.apache.mahout.ga.watchmaker.cd.tool.ToolMapper;
import org.apache.mahout.ga.watchmaker.cd.tool.ToolReducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CDInfosTool {
    private static final Logger log = LoggerFactory.getLogger(CDInfosTool.class);

    private CDInfosTool() {
    }

    public static void gatherInfos(Descriptors descriptors, Path inpath, Path output, Collection<String> descriptions) throws IOException, InterruptedException, ClassNotFoundException {
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((URI)inpath.toUri(), (Configuration)conf);
        Preconditions.checkArgument((fs.exists(inpath) && fs.getFileStatus(inpath).isDir() ? 1 : 0) != 0, (String)"%s is not a directory", (Object[])new Object[]{inpath});
        Job job = new Job(conf);
        CDInfosTool.configureJob(job, descriptors, inpath, output);
        job.waitForCompletion(true);
        CDInfosTool.importDescriptions(fs, conf, output, descriptions);
    }

    private static void configureJob(Job job, Descriptors descriptors, Path inpath, Path outpath) throws IOException {
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{inpath});
        FileOutputFormat.setOutputPath((Job)job, (Path)outpath);
        job.setJarByClass(CDInfosTool.class);
        job.setOutputKeyClass(LongWritable.class);
        job.setOutputValueClass(Text.class);
        job.setMapperClass(ToolMapper.class);
        job.setCombinerClass(ToolCombiner.class);
        job.setReducerClass(ToolReducer.class);
        job.setInputFormatClass(TextInputFormat.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.getConfiguration().set("cdtool.attributes", new String(descriptors.getChars()));
    }

    private static void importDescriptions(FileSystem fs, Configuration conf, Path outpath, Collection<String> descriptions) throws IOException {
        SequenceFile.Sorter sorter = new SequenceFile.Sorter(fs, LongWritable.class, Text.class, conf);
        Path[] outfiles = OutputUtils.listOutputFiles((FileSystem)fs, (Path)outpath);
        Path output = new Path(outpath, "output.sorted");
        sorter.merge(outfiles, output);
        for (Writable value : new SequenceFileValueIterable(output, true, conf)) {
            descriptions.add(value.toString());
        }
    }

    private static Descriptors loadDescriptors(FileSystem fs, Path inpath) throws IOException {
        Path infpath = FileInfoParser.getInfoFile(fs, inpath);
        FSDataInputStream input = fs.open(infpath);
        Scanner reader = new Scanner((InputStream)input);
        ArrayList<Character> descriptors = new ArrayList<Character>();
        while (reader.hasNextLine()) {
            String c = reader.nextLine();
            descriptors.add(Character.valueOf(c.toUpperCase(Locale.ENGLISH).charAt(0)));
        }
        if (descriptors.isEmpty()) {
            throw new IllegalArgumentException("Infos file is empty");
        }
        char[] desc = new char[descriptors.size()];
        for (int index = 0; index < descriptors.size(); ++index) {
            desc[index] = ((Character)descriptors.get(index)).charValue();
        }
        return new Descriptors(desc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeDescriptions(FileSystem fs, Path inpath, Descriptors descriptors, List<String> descriptions) throws IOException {
        Path infpath = FileInfoParser.getInfoFile(fs, inpath);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(infpath)));
        try {
            int aindex = 0;
            for (int index = 0; index < descriptors.size(); ++index) {
                if (descriptors.isLabel(index)) {
                    writer.write("LABEL, ");
                    writer.write(descriptions.get(aindex++));
                } else if (descriptors.isNumerical(index)) {
                    writer.write("NUMERICAL, ");
                    writer.write(descriptions.get(aindex++));
                } else if (descriptors.isNominal(index)) {
                    writer.write("CATEGORICAL, ");
                    writer.write(descriptions.get(aindex++));
                } else {
                    writer.write("IGNORED");
                }
                writer.newLine();
            }
        }
        finally {
            writer.close();
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException, ClassNotFoundException {
        DefaultOptionBuilder obuilder = new DefaultOptionBuilder();
        ArgumentBuilder abuilder = new ArgumentBuilder();
        GroupBuilder gbuilder = new GroupBuilder();
        DefaultOption inputOpt = obuilder.withLongName("input").withRequired(true).withShortName("i").withArgument(abuilder.withName("input").withMinimum(1).withMaximum(1).create()).withDescription("The Path for input data directory.").create();
        Option helpOpt = DefaultOptionCreator.helpOption();
        Group group = gbuilder.withName("Options").withOption((Option)inputOpt).withOption(helpOpt).create();
        Parser parser = new Parser();
        parser.setGroup(group);
        try {
            CommandLine cmdLine = parser.parse(args);
            if (cmdLine.hasOption(helpOpt)) {
                CommandLineUtil.printHelp((Group)group);
                return;
            }
            Path input = new Path(cmdLine.getValue((Option)inputOpt).toString());
            Path output = new Path("output");
            FileSystem fs = FileSystem.get((URI)input.toUri(), (Configuration)new Configuration());
            log.info("Loading Descriptors...");
            Descriptors descriptors = CDInfosTool.loadDescriptors(fs, input);
            log.info("Gathering informations...");
            ArrayList<String> descriptions = new ArrayList<String>();
            CDInfosTool.gatherInfos(descriptors, input, output, descriptions);
            log.info("Storing Descriptions...");
            CDInfosTool.storeDescriptions(fs, input, descriptors, descriptions);
        }
        catch (OptionException e) {
            log.error("Error while parsing options", (Throwable)e);
            CommandLineUtil.printHelp((Group)group);
        }
    }
}

