/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.ga.watchmaker.cd.hadoop;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;

public final class DatasetSplit {
    private static final String SEED = "traintest.seed";
    private static final String THRESHOLD = "traintest.threshold";
    private static final String TRAINING = "traintest.training";
    private final long seed;
    private final double threshold;
    private boolean training;

    public DatasetSplit(long seed, double threshold) {
        this.seed = seed;
        this.threshold = threshold;
        this.training = true;
    }

    public DatasetSplit(double threshold) {
        this(((RandomWrapper)RandomUtils.getRandom()).getSeed(), threshold);
    }

    public DatasetSplit(Configuration conf) {
        this.seed = DatasetSplit.getSeed(conf);
        this.threshold = DatasetSplit.getThreshold(conf);
        this.training = DatasetSplit.isTraining(conf);
    }

    public long getSeed() {
        return this.seed;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public boolean isTraining() {
        return this.training;
    }

    public void setTraining(boolean training) {
        this.training = training;
    }

    public void storeJobParameters(Configuration conf) {
        conf.set(SEED, String.valueOf(this.seed));
        conf.set(THRESHOLD, Double.toString(this.threshold));
        conf.setBoolean(TRAINING, this.training);
    }

    static long getSeed(Configuration conf) {
        String seedstr = conf.get(SEED);
        Preconditions.checkArgument((seedstr != null ? 1 : 0) != 0, (String)"Job parameter %s not found", (Object[])new Object[]{SEED});
        return Long.parseLong(seedstr);
    }

    static double getThreshold(Configuration conf) {
        String thrstr = conf.get(THRESHOLD);
        Preconditions.checkArgument((thrstr != null ? 1 : 0) != 0, (String)"Job parameter %s not found", (Object[])new Object[]{THRESHOLD});
        return Double.parseDouble(thrstr);
    }

    static boolean isTraining(Configuration conf) {
        Preconditions.checkArgument((conf.get(TRAINING) != null ? 1 : 0) != 0, (String)"Job parameter %s not found", (Object[])new Object[]{TRAINING});
        return conf.getBoolean(TRAINING, true);
    }

    public static class DatasetTextInputFormat
    extends TextInputFormat {
        public RecordReader<LongWritable, Text> createRecordReader(InputSplit split, TaskAttemptContext context) {
            return new RndLineRecordReader((RecordReader<LongWritable, Text>)super.createRecordReader(split, context), context.getConfiguration());
        }
    }

    public static class RndLineRecordReader
    extends RecordReader<LongWritable, Text> {
        private final RecordReader<LongWritable, Text> reader;
        private final Random rng;
        private final double threshold;
        private final boolean training;
        private final LongWritable k = new LongWritable();
        private final Text v = new Text();

        public RndLineRecordReader(RecordReader<LongWritable, Text> reader, Configuration conf) {
            Preconditions.checkArgument((reader != null ? 1 : 0) != 0, (Object)"Null reader");
            this.reader = reader;
            DatasetSplit split = new DatasetSplit(conf);
            this.rng = RandomUtils.getRandom((long)split.getSeed());
            this.threshold = split.getThreshold();
            this.training = split.isTraining();
        }

        public void close() throws IOException {
            this.reader.close();
        }

        public float getProgress() throws IOException {
            try {
                return this.reader.getProgress();
            }
            catch (InterruptedException e) {
                return 0.0f;
            }
        }

        public LongWritable getCurrentKey() throws IOException, InterruptedException {
            return this.k;
        }

        public Text getCurrentValue() throws IOException, InterruptedException {
            return this.v;
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            this.reader.initialize(split, context);
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            boolean read;
            while ((read = this.reader.nextKeyValue()) && !this.selected()) {
            }
            if (!read) {
                return false;
            }
            this.k.set(((LongWritable)this.reader.getCurrentKey()).get());
            this.v.set((Text)this.reader.getCurrentValue());
            return true;
        }

        private boolean selected() {
            return this.training ? this.rng.nextDouble() < this.threshold : this.rng.nextDouble() >= this.threshold;
        }
    }
}

