/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.ga.watchmaker.cd.hadoop;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.common.StringUtils;
import org.apache.mahout.ga.watchmaker.cd.CDFitness;
import org.apache.mahout.ga.watchmaker.cd.DataLine;
import org.apache.mahout.ga.watchmaker.cd.DataSet;
import org.apache.mahout.ga.watchmaker.cd.Rule;

public class CDMapper
extends Mapper<LongWritable, Text, LongWritable, CDFitness> {
    public static final String CLASSDISCOVERY_RULES = "mahout.ga.classdiscovery.rules";
    public static final String CLASSDISCOVERY_DATASET = "mahout.ga.classdiscovery.dataset";
    public static final String CLASSDISCOVERY_TARGET_LABEL = "mahout.ga.classdiscovery.target";
    List<Rule> rules;
    int target;

    protected void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        DataLine dl = new DataLine(value.toString());
        for (int index = 0; index < this.rules.size(); ++index) {
            CDFitness eval = CDMapper.evaluate(this.target, this.rules.get(index).classify(dl), dl.getLabel());
            context.write((Object)new LongWritable((long)index), (Object)eval);
        }
    }

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration conf = context.getConfiguration();
        String rstr = conf.get(CLASSDISCOVERY_RULES);
        Preconditions.checkArgument((rstr != null ? 1 : 0) != 0, (String)"Job parameter %s not found", (Object[])new Object[]{CLASSDISCOVERY_RULES});
        String datastr = conf.get(CLASSDISCOVERY_DATASET);
        Preconditions.checkArgument((datastr != null ? 1 : 0) != 0, (String)"Job parameter %s not found", (Object[])new Object[]{CLASSDISCOVERY_DATASET});
        int target = conf.getInt(CLASSDISCOVERY_TARGET_LABEL, -1);
        Preconditions.checkArgument((target != -1 ? 1 : 0) != 0, (String)"Job parameter %s not found", (Object[])new Object[]{CLASSDISCOVERY_TARGET_LABEL});
        CDMapper.initializeDataSet((DataSet)StringUtils.fromString((String)datastr));
        this.configure((List)StringUtils.fromString((String)rstr), target);
    }

    static void initializeDataSet(DataSet dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("bad 'dataset' configuration parameter");
        }
        DataSet.initialize(dataset);
    }

    void configure(List<Rule> rules, int target) {
        Preconditions.checkArgument((rules != null && !rules.isEmpty() ? 1 : 0) != 0, (String)"Bad rules", (Object[])new Object[]{rules});
        Preconditions.checkArgument((target >= 0 ? 1 : 0) != 0, (String)"Bad target", (Object[])new Object[]{target});
        this.rules = rules;
        this.target = target;
    }

    public static CDFitness evaluate(int target, int prediction, int label) {
        boolean labelIsTarget = label == target;
        int tp = labelIsTarget && prediction == 1 ? 1 : 0;
        int fp = !labelIsTarget && prediction == 1 ? 1 : 0;
        int tn = !labelIsTarget && prediction == 0 ? 1 : 0;
        int fn = labelIsTarget && prediction == 0 ? 1 : 0;
        return new CDFitness(tp, fp, tn, fn);
    }
}

