/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.ga.watchmaker.cd.hadoop;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.mahout.common.StringUtils;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileValueIterable;
import org.apache.mahout.ga.watchmaker.OutputUtils;
import org.apache.mahout.ga.watchmaker.cd.CDFitness;
import org.apache.mahout.ga.watchmaker.cd.DataSet;
import org.apache.mahout.ga.watchmaker.cd.FileInfoParser;
import org.apache.mahout.ga.watchmaker.cd.Rule;
import org.apache.mahout.ga.watchmaker.cd.hadoop.CDMapper;
import org.apache.mahout.ga.watchmaker.cd.hadoop.CDReducer;
import org.apache.mahout.ga.watchmaker.cd.hadoop.DatasetSplit;

public final class CDMahoutEvaluator {
    private CDMahoutEvaluator() {
    }

    public static void evaluate(List<? extends Rule> rules, int target, Path inpath, Path output, Collection<CDFitness> evaluations, DatasetSplit split) throws IOException, InterruptedException, ClassNotFoundException {
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((URI)inpath.toUri(), (Configuration)conf);
        Preconditions.checkArgument((fs.exists(inpath) && fs.getFileStatus(inpath).isDir() ? 1 : 0) != 0, (String)"%s is not a directory", (Object[])new Object[]{inpath});
        Job job = new Job(conf);
        CDMahoutEvaluator.configureJob(job, rules, target, inpath, output, split);
        job.waitForCompletion(true);
        CDMahoutEvaluator.importEvaluations(fs, conf, output, evaluations);
    }

    public static void initializeDataSet(Path inpath) throws IOException {
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((URI)inpath.toUri(), (Configuration)conf);
        DataSet.initialize(FileInfoParser.parseFile(fs, inpath));
    }

    public static CDFitness evaluate(Rule rule, int target, Path inpath, Path output, DatasetSplit split) throws IOException, InterruptedException, ClassNotFoundException {
        ArrayList<CDFitness> evals = new ArrayList<CDFitness>();
        CDMahoutEvaluator.evaluate(Arrays.asList(rule), target, inpath, output, evals, split);
        return (CDFitness)evals.get(0);
    }

    public static void evaluate(List<? extends Rule> rules, int target, Path inpath, Path output, Collection<CDFitness> evaluations) throws IOException, InterruptedException, ClassNotFoundException {
        CDMahoutEvaluator.evaluate(rules, target, inpath, output, evaluations, new DatasetSplit(1.0));
    }

    private static void configureJob(Job job, List<? extends Rule> rules, int target, Path inpath, Path outpath, DatasetSplit split) throws IOException {
        split.storeJobParameters(job.getConfiguration());
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{inpath});
        FileOutputFormat.setOutputPath((Job)job, (Path)outpath);
        job.setJarByClass(CDMahoutEvaluator.class);
        job.setOutputKeyClass(LongWritable.class);
        job.setOutputValueClass(CDFitness.class);
        job.setMapperClass(CDMapper.class);
        job.setCombinerClass(CDReducer.class);
        job.setReducerClass(CDReducer.class);
        job.setInputFormatClass(DatasetSplit.DatasetTextInputFormat.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        Configuration conf = job.getConfiguration();
        conf.set("mahout.ga.classdiscovery.rules", StringUtils.toString(rules));
        conf.set("mahout.ga.classdiscovery.dataset", StringUtils.toString((Object)DataSet.getDataSet()));
        conf.setInt("mahout.ga.classdiscovery.target", target);
    }

    private static void importEvaluations(FileSystem fs, Configuration conf, Path outpath, Collection<CDFitness> evaluations) throws IOException {
        SequenceFile.Sorter sorter = new SequenceFile.Sorter(fs, LongWritable.class, CDFitness.class, conf);
        Path[] outfiles = OutputUtils.listOutputFiles((FileSystem)fs, (Path)outpath);
        Path output = new Path(outpath, "output.sorted");
        sorter.merge(outfiles, output);
        for (CDFitness value : new SequenceFileValueIterable(output, conf)) {
            evaluations.add(value);
        }
    }
}

