/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.ga.watchmaker.cd;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Scanner;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.ga.watchmaker.cd.Attribute;
import org.apache.mahout.ga.watchmaker.cd.DataSet;
import org.apache.mahout.ga.watchmaker.cd.NominalAttr;
import org.apache.mahout.ga.watchmaker.cd.NumericalAttr;

public final class FileInfoParser {
    public static final String IGNORED_TOKEN = "IGNORED";
    public static final String LABEL_TOKEN = "LABEL";
    public static final String NOMINAL_TOKEN = "CATEGORICAL";
    public static final String NUMERICAL_TOKEN = "NUMERICAL";
    private static final Splitter COMMA = Splitter.on((char)',').trimResults();

    private FileInfoParser() {
    }

    public static DataSet parseFile(FileSystem fs, Path inpath) throws IOException {
        Path info = FileInfoParser.getInfoFile(fs, inpath);
        FSDataInputStream input = fs.open(info);
        Scanner reader = new Scanner((InputStream)input);
        ArrayList<Integer> ignored = new ArrayList<Integer>();
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        int labelIndex = -1;
        int index = 0;
        while (reader.hasNextLine()) {
            String line = reader.nextLine();
            Iterator<String> tokens = COMMA.split((CharSequence)line).iterator();
            String token = (String)tokens.next();
            if (IGNORED_TOKEN.equals(token)) {
                ignored.add(index);
                continue;
            }
            if (LABEL_TOKEN.equals(token)) {
                labelIndex = index;
                attributes.add(FileInfoParser.parseNominal(tokens));
                continue;
            }
            if (NOMINAL_TOKEN.equals(token)) {
                attributes.add(FileInfoParser.parseNominal(tokens));
                continue;
            }
            if (NUMERICAL_TOKEN.equals(token)) {
                attributes.add(FileInfoParser.parseNumerical(tokens));
                continue;
            }
            throw new IllegalArgumentException("Unknown token (" + token + ") encountered while parsing the info file");
        }
        reader.close();
        if (labelIndex == -1) {
            throw new IllegalStateException("Info file does not contain a LABEL");
        }
        return new DataSet(attributes, ignored, labelIndex);
    }

    public static Path getInfoFile(FileSystem fs, Path inpath) throws IOException {
        Preconditions.checkArgument((inpath != null && fs.exists(inpath) && fs.getFileStatus(inpath).isDir() ? 1 : 0) != 0, (String)"Input path should be a directory", (Object[])new Object[]{inpath});
        Path infoPath = new Path(inpath.getParent(), inpath.getName() + ".infos");
        Preconditions.checkArgument((boolean)fs.exists(infoPath), (String)"Info file does not exist", (Object[])new Object[]{infoPath});
        return infoPath;
    }

    private static NominalAttr parseNominal(Iterator<String> tokens) {
        ArrayList<String> vlist = new ArrayList<String>();
        while (tokens.hasNext()) {
            vlist.add(tokens.next());
        }
        String[] values = new String[vlist.size()];
        vlist.toArray(values);
        return new NominalAttr(values);
    }

    private static NumericalAttr parseNumerical(Iterator<String> tokens) {
        double max;
        double min = Double.parseDouble(tokens.next());
        Preconditions.checkArgument((min <= (max = Double.parseDouble(tokens.next())) ? 1 : 0) != 0, (Object)"min > max");
        return new NumericalAttr(min, max);
    }
}

