/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.ga.watchmaker.cd;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.mahout.ga.watchmaker.cd.Attribute;
import org.apache.mahout.ga.watchmaker.cd.NominalAttr;
import org.apache.mahout.ga.watchmaker.cd.NumericalAttr;

public class DataSet {
    private static DataSet dataset;
    private final List<Integer> ignoredAttributes;
    private final int labelIndex;
    private final List<Attribute> attributes;

    DataSet() {
        this(null, null, 0);
    }

    DataSet(List<Attribute> attributes, List<Integer> ignored, int labelIndex) {
        this.attributes = attributes;
        this.ignoredAttributes = ignored;
        this.labelIndex = labelIndex;
    }

    public static DataSet getDataSet() {
        if (dataset == null) {
            throw new IllegalStateException("DataSet not initialized");
        }
        return dataset;
    }

    public static void initialize(DataSet dataset) {
        DataSet.dataset = dataset;
    }

    public int getNbAttributes() {
        return this.attributes.size();
    }

    public List<Integer> getIgnoredAttributes() {
        return this.ignoredAttributes;
    }

    public int getLabelIndex() {
        return this.labelIndex;
    }

    public double getMax(int index) {
        Preconditions.checkArgument((boolean)this.isNumerical(index), (Object)"Nominal attribute");
        return ((NumericalAttr)this.attributes.get(index)).getMax();
    }

    public double getMin(int index) {
        Preconditions.checkArgument((boolean)this.isNumerical(index), (Object)"Nominal attribute");
        return ((NumericalAttr)this.attributes.get(index)).getMin();
    }

    public int getNbValues(int index) {
        Preconditions.checkArgument((!this.isNumerical(index) ? 1 : 0) != 0, (Object)"Numerical attribute");
        return ((NominalAttr)this.attributes.get(index)).getNbvalues();
    }

    public boolean isNumerical(int index) {
        return this.attributes.get(index).isNumerical();
    }

    public int valueIndex(int index, String value) {
        Preconditions.checkArgument((!this.isNumerical(index) ? 1 : 0) != 0, (Object)"Numerical attribute");
        return ((NominalAttr)this.attributes.get(index)).valueIndex(value);
    }
}

