/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.ga.watchmaker.cd;

import com.google.common.base.Preconditions;
import java.util.Random;
import org.apache.mahout.ga.watchmaker.cd.DataLine;
import org.apache.mahout.ga.watchmaker.cd.DataSet;
import org.apache.mahout.ga.watchmaker.cd.Rule;
import org.uncommons.maths.binary.BitString;

public final class CDRule
implements Rule {
    private final double threshold;
    private final int nbConditions;
    private final double[] weights;
    private final BitString operators;
    private final double[] values;

    public CDRule(double threshold) {
        Preconditions.checkArgument((threshold >= 0.0 && threshold <= 1.0 ? 1 : 0) != 0, (Object)"Threshold must be in [0,1]");
        this.threshold = threshold;
        this.nbConditions = DataSet.getDataSet().getNbAttributes() - 1;
        this.weights = new double[this.nbConditions];
        this.operators = new BitString(this.nbConditions);
        this.values = new double[this.nbConditions];
    }

    public CDRule(double threshold, Random rng) {
        this(threshold);
        DataSet dataset = DataSet.getDataSet();
        for (int condInd = 0; condInd < this.nbConditions; ++condInd) {
            int attrInd = CDRule.attributeIndex(condInd);
            this.setW(condInd, rng.nextDouble());
            this.setO(condInd, rng.nextBoolean());
            if (dataset.isNumerical(attrInd)) {
                this.setV(condInd, CDRule.randomNumerical(dataset, attrInd, rng));
                continue;
            }
            this.setV(condInd, CDRule.randomCategorical(dataset, attrInd, rng));
        }
    }

    public CDRule(CDRule ind) {
        this.threshold = ind.threshold;
        this.nbConditions = ind.nbConditions;
        this.weights = (double[])ind.weights.clone();
        this.operators = ind.operators.clone();
        this.values = (double[])ind.values.clone();
    }

    private static double randomNumerical(DataSet dataset, int attrInd, Random rng) {
        double max = dataset.getMax(attrInd);
        double min = dataset.getMin(attrInd);
        return rng.nextDouble() * (max - min) + min;
    }

    private static double randomCategorical(DataSet dataset, int attrInd, Random rng) {
        int nbcategories = dataset.getNbValues(attrInd);
        return rng.nextInt(nbcategories);
    }

    @Override
    public int classify(DataLine dl) {
        for (int condInd = 0; condInd < this.nbConditions; ++condInd) {
            if (this.condition(condInd, dl)) continue;
            return 0;
        }
        return 1;
    }

    public static int attributeIndex(int condInd) {
        int labelpos = DataSet.getDataSet().getLabelIndex();
        return condInd < labelpos ? condInd : condInd + 1;
    }

    boolean condition(int condInd, DataLine dl) {
        int attrInd = CDRule.attributeIndex(condInd);
        if (this.getW(condInd) < this.threshold) {
            return true;
        }
        return DataSet.getDataSet().isNumerical(attrInd) ? this.numericalCondition(condInd, dl) : this.categoricalCondition(condInd, dl);
    }

    boolean numericalCondition(int condInd, DataLine dl) {
        int attrInd = CDRule.attributeIndex(condInd);
        return this.getO(condInd) ? dl.getAttribute(attrInd) >= this.getV(condInd) : dl.getAttribute(attrInd) < this.getV(condInd);
    }

    boolean categoricalCondition(int condInd, DataLine dl) {
        int attrInd = CDRule.attributeIndex(condInd);
        return this.getO(condInd) ? dl.getAttribute(attrInd) == this.getV(condInd) : dl.getAttribute(attrInd) != this.getV(condInd);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("CDRule = [");
        boolean empty = true;
        for (int condInd = 0; condInd < this.nbConditions; ++condInd) {
            if (!(this.getW(condInd) >= this.threshold)) continue;
            if (!empty) {
                buffer.append(" && ");
            }
            buffer.append("attr").append(CDRule.attributeIndex(condInd)).append(' ').append(this.getO(condInd) ? ">=" : "<");
            buffer.append(' ').append(this.getV(condInd));
            empty = false;
        }
        buffer.append(']');
        return buffer.toString();
    }

    public int getNbConditions() {
        return this.nbConditions;
    }

    public double getW(int index) {
        return this.weights[index];
    }

    public void setW(int index, double w) {
        this.weights[index] = w;
    }

    public boolean getO(int index) {
        return this.operators.getBit(index);
    }

    public void setO(int index, boolean o) {
        this.operators.setBit(index, o);
    }

    public double getV(int index) {
        return this.values[index];
    }

    public void setV(int index, double v) {
        this.values[index] = v;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CDRule)) {
            return false;
        }
        CDRule rule = (CDRule)obj;
        for (int index = 0; index < this.nbConditions; ++index) {
            if (CDRule.areGenesEqual(this, rule, index)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int value = 0;
        for (int index = 0; index < this.nbConditions; ++index) {
            value = (int)((double)(value *= 31) + ((double)(Double.doubleToLongBits(this.getW(index)) + (long)(this.getO(index) ? 1 : 0)) + this.getV(index)));
        }
        return value;
    }

    public static boolean areGenesEqual(CDRule rule1, CDRule rule2, int index) {
        return rule1.getW(index) == rule2.getW(index) && rule1.getO(index) == rule2.getO(index) && rule1.getV(index) == rule2.getV(index);
    }

    public boolean areGenesEqual(int index1, int index2) {
        return this.getW(index1) == this.getW(index2) && this.getO(index1) == this.getO(index2) && this.getV(index1) == this.getV(index2);
    }
}

