/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.ga.watchmaker.cd;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.mahout.ga.watchmaker.cd.CDRule;
import org.apache.mahout.ga.watchmaker.cd.DataSet;
import org.uncommons.watchmaker.framework.EvolutionaryOperator;

public class CDMutation
implements EvolutionaryOperator<CDRule> {
    private final double rate;
    private final double range;
    private final int k;

    public CDMutation(double rate, double range, int k) {
        Preconditions.checkArgument((rate > 0.0 && rate <= 1.0 ? 1 : 0) != 0, (Object)"mutation rate must be in (0, 1]");
        Preconditions.checkArgument((range > 0.0 && range <= 1.0 ? 1 : 0) != 0, (Object)"mutation range must be in (0, 1]");
        Preconditions.checkArgument((k >= 0 ? 1 : 0) != 0, (Object)"mutation precision must be nonnegative");
        this.rate = rate;
        this.range = range;
        this.k = k;
    }

    public List<CDRule> apply(List<CDRule> selectedCandidates, Random rng) {
        ArrayList<CDRule> mutatedPopulation = new ArrayList<CDRule>(selectedCandidates.size());
        for (CDRule ind : selectedCandidates) {
            mutatedPopulation.add(this.mutate(ind, rng));
        }
        return mutatedPopulation;
    }

    protected CDRule mutate(CDRule rule, Random rng) {
        DataSet dataset = DataSet.getDataSet();
        for (int condInd = 0; condInd < rule.getNbConditions(); ++condInd) {
            if (rng.nextDouble() > this.rate) continue;
            int attrInd = CDRule.attributeIndex(condInd);
            rule.setW(condInd, this.rndDouble(rule.getW(condInd), 0.0, 1.0, rng));
            if (dataset.isNumerical(attrInd)) {
                rule.setV(condInd, this.rndDouble(rule.getV(condInd), dataset.getMin(attrInd), dataset.getMax(attrInd), rng));
                continue;
            }
            rule.setV(condInd, CDMutation.rndInt(rule.getV(condInd), dataset.getNbValues(attrInd), rng));
        }
        return rule;
    }

    double rndDouble(double value, double min, double max, Random rng) {
        double s = rng.nextDouble() * 2.0 - 1.0;
        double r = this.range * (max - min) / 2.0;
        double a = Math.pow(2.0, (double)(-this.k) * rng.nextDouble());
        double stp = s * r * a;
        value += stp;
        value = Math.max(min, value);
        value = Math.min(max, value);
        return value;
    }

    static int rndInt(double value, int nbcategories, Random rng) {
        return rng.nextInt(nbcategories);
    }
}

