/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.ga.watchmaker.cd;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.common.CommandLineUtil;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.apache.mahout.ga.watchmaker.cd.CDCrossover;
import org.apache.mahout.ga.watchmaker.cd.CDFactory;
import org.apache.mahout.ga.watchmaker.cd.CDFitness;
import org.apache.mahout.ga.watchmaker.cd.CDFitnessEvaluator;
import org.apache.mahout.ga.watchmaker.cd.CDMutation;
import org.apache.mahout.ga.watchmaker.cd.CDRule;
import org.apache.mahout.ga.watchmaker.cd.Rule;
import org.apache.mahout.ga.watchmaker.cd.hadoop.CDMahoutEvaluator;
import org.apache.mahout.ga.watchmaker.cd.hadoop.DatasetSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uncommons.watchmaker.framework.CandidateFactory;
import org.uncommons.watchmaker.framework.EvolutionObserver;
import org.uncommons.watchmaker.framework.EvolutionaryOperator;
import org.uncommons.watchmaker.framework.FitnessEvaluator;
import org.uncommons.watchmaker.framework.PopulationData;
import org.uncommons.watchmaker.framework.SelectionStrategy;
import org.uncommons.watchmaker.framework.SequentialEvolutionEngine;
import org.uncommons.watchmaker.framework.TerminationCondition;
import org.uncommons.watchmaker.framework.operators.EvolutionPipeline;
import org.uncommons.watchmaker.framework.selection.RouletteWheelSelection;
import org.uncommons.watchmaker.framework.termination.GenerationCount;

public final class CDGA {
    private static final Logger log = LoggerFactory.getLogger(CDGA.class);

    private CDGA() {
    }

    public static void main(String[] args) throws IOException, InterruptedException, ClassNotFoundException {
        DefaultOptionBuilder obuilder = new DefaultOptionBuilder();
        ArgumentBuilder abuilder = new ArgumentBuilder();
        GroupBuilder gbuilder = new GroupBuilder();
        DefaultOption inputOpt = obuilder.withLongName("input").withRequired(true).withShortName("i").withArgument(abuilder.withName("input").withMinimum(1).withMaximum(1).create()).withDescription("The Path for input data directory.").create();
        DefaultOption labelOpt = obuilder.withLongName("label").withRequired(true).withShortName("l").withArgument(abuilder.withName("index").withMinimum(1).withMaximum(1).create()).withDescription("label's index.").create();
        DefaultOption thresholdOpt = obuilder.withLongName("threshold").withRequired(false).withShortName("t").withArgument(abuilder.withName("threshold").withMinimum(1).withMaximum(1).create()).withDescription("Condition activation threshold, default = 0.5.").create();
        DefaultOption crosspntsOpt = obuilder.withLongName("crosspnts").withRequired(false).withShortName("cp").withArgument(abuilder.withName("points").withMinimum(1).withMaximum(1).create()).withDescription("Number of crossover points to use, default = 1.").create();
        DefaultOption mutrateOpt = obuilder.withLongName("mutrate").withRequired(true).withShortName("m").withArgument(abuilder.withName("true").withMinimum(1).withMaximum(1).create()).withDescription("Mutation rate (float).").create();
        DefaultOption mutrangeOpt = obuilder.withLongName("mutrange").withRequired(false).withShortName("mr").withArgument(abuilder.withName("range").withMinimum(1).withMaximum(1).create()).withDescription("Mutation range, default = 0.1 (10%).").create();
        DefaultOption mutprecOpt = obuilder.withLongName("mutprec").withRequired(false).withShortName("mp").withArgument(abuilder.withName("precision").withMinimum(1).withMaximum(1).create()).withDescription("Mutation precision, default = 2.").create();
        DefaultOption popsizeOpt = obuilder.withLongName("popsize").withRequired(true).withShortName("p").withArgument(abuilder.withName("size").withMinimum(1).withMaximum(1).create()).withDescription("Population size.").create();
        DefaultOption gencntOpt = obuilder.withLongName("gencnt").withRequired(true).withShortName("g").withArgument(abuilder.withName("count").withMinimum(1).withMaximum(1).create()).withDescription("Generations count.").create();
        Option helpOpt = DefaultOptionCreator.helpOption();
        Group group = gbuilder.withName("Options").withOption((Option)inputOpt).withOption(helpOpt).withOption((Option)labelOpt).withOption((Option)thresholdOpt).withOption((Option)crosspntsOpt).withOption((Option)mutrateOpt).withOption((Option)mutrangeOpt).withOption((Option)mutprecOpt).withOption((Option)popsizeOpt).withOption((Option)gencntOpt).create();
        Parser parser = new Parser();
        parser.setGroup(group);
        try {
            CommandLine cmdLine = parser.parse(args);
            if (cmdLine.hasOption(helpOpt)) {
                CommandLineUtil.printHelp((Group)group);
                return;
            }
            String dataset = cmdLine.getValue((Option)inputOpt).toString();
            int target = Integer.parseInt(cmdLine.getValue((Option)labelOpt).toString());
            double threshold = cmdLine.hasOption((Option)thresholdOpt) ? Double.parseDouble(cmdLine.getValue((Option)thresholdOpt).toString()) : 0.5;
            int crosspnts = cmdLine.hasOption((Option)crosspntsOpt) ? Integer.parseInt(cmdLine.getValue((Option)crosspntsOpt).toString()) : 1;
            double mutrate = Double.parseDouble(cmdLine.getValue((Option)mutrateOpt).toString());
            double mutrange = cmdLine.hasOption((Option)mutrangeOpt) ? Double.parseDouble(cmdLine.getValue((Option)mutrangeOpt).toString()) : 0.1;
            int mutprec = cmdLine.hasOption((Option)mutprecOpt) ? Integer.parseInt(cmdLine.getValue((Option)mutprecOpt).toString()) : 2;
            int popSize = Integer.parseInt(cmdLine.getValue((Option)popsizeOpt).toString());
            int genCount = Integer.parseInt(cmdLine.getValue((Option)gencntOpt).toString());
            long start = System.currentTimeMillis();
            CDGA.runJob(dataset, target, threshold, crosspnts, mutrate, mutrange, mutprec, popSize, genCount);
            long end = System.currentTimeMillis();
            CDGA.printElapsedTime(end - start);
        }
        catch (OptionException e) {
            log.error("Error while parsing options", (Throwable)e);
            CommandLineUtil.printHelp((Group)group);
        }
    }

    private static void runJob(String dataset, int target, double threshold, int crosspnts, double mutrate, double mutrange, int mutprec, int popSize, int genCount) throws IOException, InterruptedException, ClassNotFoundException {
        Path inpath = new Path(dataset);
        CDMahoutEvaluator.initializeDataSet(inpath);
        CDFactory factory = new CDFactory(threshold);
        ArrayList<Object> operators = new ArrayList<Object>();
        operators.add((Object)new CDCrossover(crosspnts));
        operators.add(new CDMutation(mutrate, mutrange, mutprec));
        EvolutionPipeline pipeline = new EvolutionPipeline(operators);
        DatasetSplit split = new DatasetSplit(0.75);
        CDFitnessEvaluator evaluator = new CDFitnessEvaluator(dataset, target, split);
        RouletteWheelSelection selection = new RouletteWheelSelection();
        SequentialEvolutionEngine engine = new SequentialEvolutionEngine((CandidateFactory)factory, (EvolutionaryOperator)pipeline, (FitnessEvaluator)evaluator, (SelectionStrategy)selection, RandomUtils.getRandom());
        engine.addEvolutionObserver((EvolutionObserver)new EvolutionObserver<CDRule>(){

            public void populationUpdate(PopulationData<? extends CDRule> data) {
                log.info("Generation {}", (Object)data.getGenerationNumber());
            }
        });
        Rule solution = (Rule)engine.evolve(popSize, 1, new TerminationCondition[]{new GenerationCount(genCount)});
        Path output = new Path("output");
        CDFitness bestTrainFit = CDMahoutEvaluator.evaluate(solution, target, inpath, output, split);
        split.setTraining(false);
        CDFitness bestTestFit = CDMahoutEvaluator.evaluate(solution, target, inpath, output, split);
        log.info("Best solution fitness (train set) : {}", (Object)bestTrainFit);
        log.info("Best solution fitness (test set) : {}", (Object)bestTestFit);
    }

    private static void printElapsedTime(long milli) {
        long seconds = milli / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        log.info("Elapsed time (Hours:minutes:seconds:milli) : {}:{}:{}:{}", new Object[]{hours, minutes %= 60L, seconds %= 60L, milli %= 1000L});
    }
}

