/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.ga.watchmaker.cd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.ga.watchmaker.STFitnessEvaluator;
import org.apache.mahout.ga.watchmaker.cd.CDFitness;
import org.apache.mahout.ga.watchmaker.cd.Rule;
import org.apache.mahout.ga.watchmaker.cd.hadoop.CDMahoutEvaluator;
import org.apache.mahout.ga.watchmaker.cd.hadoop.DatasetSplit;

public class CDFitnessEvaluator
extends STFitnessEvaluator<Rule> {
    private final Path dataset;
    private final DatasetSplit split;
    private final Collection<CDFitness> evals = new ArrayList<CDFitness>();
    private final int target;

    public CDFitnessEvaluator(String dataset, int target, DatasetSplit split) {
        this.dataset = new Path(dataset);
        this.target = target;
        this.split = split;
    }

    public boolean isNatural() {
        return true;
    }

    protected void evaluate(List<? extends Rule> population, List<Double> evaluations) {
        this.evals.clear();
        Path output = new Path("output");
        try {
            CDMahoutEvaluator.evaluate(population, this.target, this.dataset, output, this.evals, this.split);
        }
        catch (IOException e) {
            throw new IllegalStateException("Exception while evaluating the population", e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Exception while evaluating the population", e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Exception while evaluating the population", e);
        }
        for (CDFitness fitness : this.evals) {
            evaluations.add(fitness.get());
        }
    }
}

