/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.ga.watchmaker.cd;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;

public class CDFitness
implements Writable {
    private int tp;
    private int fp;
    private int tn;
    private int fn;

    public CDFitness() {
    }

    public CDFitness(CDFitness f) {
        this.tp = f.getTp();
        this.fp = f.getFp();
        this.tn = f.getTn();
        this.fn = f.getFn();
    }

    public CDFitness(int tp, int fp, int tn, int fn) {
        this.tp = tp;
        this.fp = fp;
        this.tn = tn;
        this.fn = fn;
    }

    public int getTp() {
        return this.tp;
    }

    public int getFp() {
        return this.fp;
    }

    public int getTn() {
        return this.tn;
    }

    public int getFn() {
        return this.fn;
    }

    public void add(CDFitness f) {
        this.tp += f.getTp();
        this.fp += f.getFp();
        this.tn += f.getTn();
        this.fn += f.getFn();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CDFitness)) {
            return false;
        }
        CDFitness f = (CDFitness)obj;
        return this.tp == f.getTp() && this.fp == f.getFp() && this.tn == f.getTn() && this.fn == f.getFn();
    }

    public int hashCode() {
        return this.tp + 31 * (this.fp + 31 * (this.tn + 31 * this.fn));
    }

    public String toString() {
        return "[TP=" + this.tp + ", FP=" + this.fp + ", TN=" + this.tn + ", FN=" + this.fn + ']';
    }

    public double get() {
        double se = (double)this.tp / (double)(this.tp + this.fn);
        double sp = (double)this.tn / (double)(this.tn + this.fp);
        return se * sp;
    }

    public void readFields(DataInput in) throws IOException {
        this.tp = in.readInt();
        this.fp = in.readInt();
        this.tn = in.readInt();
        this.fn = in.readInt();
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.tp);
        out.writeInt(this.fp);
        out.writeInt(this.tn);
        out.writeInt(this.fn);
    }
}

