/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.ga.watchmaker.cd;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.mahout.ga.watchmaker.cd.CDRule;
import org.uncommons.maths.random.Probability;
import org.uncommons.watchmaker.framework.operators.AbstractCrossover;

public class CDCrossover
extends AbstractCrossover<CDRule> {
    public CDCrossover(int crossoverPoints) {
        super(crossoverPoints);
    }

    public CDCrossover(int crossoverPoints, Probability crossoverProbability) {
        super(crossoverPoints, crossoverProbability);
    }

    protected List<CDRule> mate(CDRule parent1, CDRule parent2, int numberOfCrossoverPoints, Random rng) {
        Preconditions.checkArgument((parent1.getNbConditions() == parent2.getNbConditions() ? 1 : 0) != 0, (Object)"Cannot perform cross-over with parents of different size.");
        CDRule offspring1 = new CDRule(parent1);
        CDRule offspring2 = new CDRule(parent2);
        for (int i = 0; i < numberOfCrossoverPoints; ++i) {
            int crossoverIndex = 1 + rng.nextInt(parent1.getNbConditions() - 1);
            for (int j = 0; j < crossoverIndex; ++j) {
                CDCrossover.swap(offspring1, offspring2, j);
            }
        }
        ArrayList<CDRule> result = new ArrayList<CDRule>(2);
        result.add(offspring1);
        result.add(offspring2);
        return result;
    }

    static void swap(CDRule ind1, CDRule ind2, int index) {
        double dtemp = ind1.getW(index);
        ind1.setW(index, ind2.getW(index));
        ind2.setW(index, dtemp);
        boolean btemp = ind1.getO(index);
        ind1.setO(index, ind2.getO(index));
        ind2.setO(index, btemp);
        dtemp = ind1.getV(index);
        ind1.setV(index, ind2.getV(index));
        ind2.setV(index, dtemp);
    }
}

