/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.fpm.pfpgrowth.dataset;

import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.common.Parameters;
import org.apache.mahout.common.StringTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyBasedStringTupleMapper
extends Mapper<LongWritable, Text, Text, StringTuple> {
    private static final Logger log = LoggerFactory.getLogger(KeyBasedStringTupleMapper.class);
    private Pattern splitter;
    private int[] selectedFields;
    private int[] groupingFields;

    protected void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        String[] fields = this.splitter.split(value.toString());
        if (fields.length != 4) {
            log.info("{} {}", (Object)fields.length, (Object)value.toString());
            context.getCounter("Map", "ERROR").increment(1L);
            return;
        }
        ArrayList<String> oKey = new ArrayList<String>();
        for (int groupingField : this.groupingFields) {
            oKey.add(fields[groupingField]);
            context.setStatus(fields[groupingField]);
        }
        ArrayList<String> oValue = new ArrayList<String>();
        for (int selectedField : this.selectedFields) {
            oValue.add(fields[selectedField]);
        }
        context.write((Object)new Text(((Object)oKey).toString()), (Object)new StringTuple(oValue));
    }

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Parameters params = new Parameters(context.getConfiguration().get("job.parameters", ""));
        this.splitter = Pattern.compile(params.get("splitPattern", "[ \t]*\t[ \t]*"));
        int selectedFieldCount = Integer.valueOf(params.get("selectedFieldCount", "0"));
        this.selectedFields = new int[selectedFieldCount];
        for (int i = 0; i < selectedFieldCount; ++i) {
            this.selectedFields[i] = Integer.valueOf(params.get("field" + i, "0"));
        }
        int groupingFieldCount = Integer.valueOf(params.get("groupingFieldCount", "0"));
        this.groupingFields = new int[groupingFieldCount];
        for (int i = 0; i < groupingFieldCount; ++i) {
            this.groupingFields[i] = Integer.valueOf(params.get("gfield" + i, "0"));
        }
    }
}

