/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.fpm.pfpgrowth.dataset;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.Parameters;
import org.apache.mahout.common.StringTuple;
import org.apache.mahout.fpm.pfpgrowth.dataset.KeyBasedStringTupleCombiner;
import org.apache.mahout.fpm.pfpgrowth.dataset.KeyBasedStringTupleMapper;
import org.apache.mahout.fpm.pfpgrowth.dataset.KeyBasedStringTupleReducer;

public final class KeyBasedStringTupleGrouper {
    private KeyBasedStringTupleGrouper() {
    }

    public static void startJob(Parameters params) throws IOException, InterruptedException, ClassNotFoundException {
        Configuration conf = new Configuration();
        conf.set("job.parameters", params.toString());
        conf.set("mapred.compress.map.output", "true");
        conf.set("mapred.output.compression.type", "BLOCK");
        conf.set("mapred.map.output.compression.codec", "org.apache.hadoop.io.compress.GzipCodec");
        conf.set("io.serializations", "org.apache.hadoop.io.serializer.JavaSerialization,org.apache.hadoop.io.serializer.WritableSerialization");
        String input = params.get("input");
        Job job = new Job(conf, "Generating dataset based from input" + input);
        job.setJarByClass(KeyBasedStringTupleGrouper.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(StringTuple.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        FileInputFormat.addInputPath((Job)job, (Path)new Path(input));
        Path outPath = new Path(params.get("output"));
        FileOutputFormat.setOutputPath((Job)job, (Path)outPath);
        HadoopUtil.delete((Configuration)conf, (Path[])new Path[]{outPath});
        job.setInputFormatClass(TextInputFormat.class);
        job.setMapperClass(KeyBasedStringTupleMapper.class);
        job.setCombinerClass(KeyBasedStringTupleCombiner.class);
        job.setReducerClass(KeyBasedStringTupleReducer.class);
        job.setOutputFormatClass(TextOutputFormat.class);
        job.waitForCompletion(true);
    }
}

