/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.fpm.pfpgrowth;

import java.io.IOException;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.mahout.common.CommandLineUtil;
import org.apache.mahout.common.Parameters;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.apache.mahout.fpm.pfpgrowth.dataset.KeyBasedStringTupleGrouper;

public final class DeliciousTagsExample {
    private DeliciousTagsExample() {
    }

    public static void main(String[] args) throws IOException, InterruptedException, ClassNotFoundException {
        DefaultOptionBuilder obuilder = new DefaultOptionBuilder();
        ArgumentBuilder abuilder = new ArgumentBuilder();
        GroupBuilder gbuilder = new GroupBuilder();
        DefaultOption inputDirOpt = DefaultOptionCreator.inputOption().create();
        DefaultOption outputOpt = DefaultOptionCreator.outputOption().create();
        Option helpOpt = DefaultOptionCreator.helpOption();
        DefaultOption recordSplitterOpt = obuilder.withLongName("splitterPattern").withArgument(abuilder.withName("splitterPattern").withMinimum(1).withMaximum(1).create()).withDescription("Regular Expression pattern used to split given line into fields. Default value splits comma or tab separated fields. Default Value: \"[ ,\\t]*\\t[ ,\\t]*\" ").withShortName("regex").create();
        DefaultOption encodingOpt = obuilder.withLongName("encoding").withArgument(abuilder.withName("encoding").withMinimum(1).withMaximum(1).create()).withDescription("(Optional) The file encoding.  Default value: UTF-8").withShortName("e").create();
        Group group = gbuilder.withName("Options").withOption((Option)inputDirOpt).withOption((Option)outputOpt).withOption(helpOpt).withOption((Option)recordSplitterOpt).withOption((Option)encodingOpt).create();
        try {
            Parser parser = new Parser();
            parser.setGroup(group);
            CommandLine cmdLine = parser.parse(args);
            if (cmdLine.hasOption(helpOpt)) {
                CommandLineUtil.printHelp((Group)group);
                return;
            }
            Parameters params = new Parameters();
            if (cmdLine.hasOption((Option)recordSplitterOpt)) {
                params.set("splitPattern", (String)cmdLine.getValue((Option)recordSplitterOpt));
            }
            String encoding = "UTF-8";
            if (cmdLine.hasOption((Option)encodingOpt)) {
                encoding = (String)cmdLine.getValue((Option)encodingOpt);
            }
            params.set("encoding", encoding);
            String inputDir = (String)cmdLine.getValue((Option)inputDirOpt);
            String outputDir = (String)cmdLine.getValue((Option)outputOpt);
            params.set("input", inputDir);
            params.set("output", outputDir);
            params.set("groupingFieldCount", "2");
            params.set("gfield0", "1");
            params.set("gfield1", "2");
            params.set("selectedFieldCount", "1");
            params.set("field0", "3");
            params.set("maxTransactionLength", "100");
            KeyBasedStringTupleGrouper.startJob(params);
        }
        catch (OptionException ex) {
            CommandLineUtil.printHelp((Group)group);
        }
    }
}

