/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.df.mapreduce;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Random;
import java.util.Scanner;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.classifier.ClassifierResult;
import org.apache.mahout.classifier.ResultAnalyzer;
import org.apache.mahout.common.CommandLineUtil;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.df.DFUtils;
import org.apache.mahout.df.DecisionForest;
import org.apache.mahout.df.data.DataConverter;
import org.apache.mahout.df.data.Dataset;
import org.apache.mahout.df.data.Instance;
import org.apache.mahout.df.mapreduce.Classifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestForest
extends Configured
implements Tool {
    private static final Logger log = LoggerFactory.getLogger(TestForest.class);
    private FileSystem dataFS;
    private Path dataPath;
    private Path datasetPath;
    private Path modelPath;
    private FileSystem outFS;
    private Path outputPath;
    private boolean analyze;
    private boolean useMapreduce;

    public int run(String[] args) throws IOException, ClassNotFoundException, InterruptedException {
        DefaultOptionBuilder obuilder = new DefaultOptionBuilder();
        ArgumentBuilder abuilder = new ArgumentBuilder();
        GroupBuilder gbuilder = new GroupBuilder();
        DefaultOption inputOpt = obuilder.withLongName("input").withShortName("i").withRequired(true).withArgument(abuilder.withName("path").withMinimum(1).withMaximum(1).create()).withDescription("Test data path").create();
        DefaultOption datasetOpt = obuilder.withLongName("dataset").withShortName("ds").withRequired(true).withArgument(abuilder.withName("dataset").withMinimum(1).withMaximum(1).create()).withDescription("Dataset path").create();
        DefaultOption modelOpt = obuilder.withLongName("model").withShortName("m").withRequired(true).withArgument(abuilder.withName("path").withMinimum(1).withMaximum(1).create()).withDescription("Path to the Decision Forest").create();
        DefaultOption outputOpt = obuilder.withLongName("output").withShortName("o").withRequired(false).withArgument(abuilder.withName("output").withMinimum(1).withMaximum(1).create()).withDescription("Path to generated predictions file").create();
        DefaultOption analyzeOpt = obuilder.withLongName("analyze").withShortName("a").withRequired(false).create();
        DefaultOption mrOpt = obuilder.withLongName("mapreduce").withShortName("mr").withRequired(false).create();
        DefaultOption helpOpt = obuilder.withLongName("help").withDescription("Print out help").withShortName("h").create();
        Group group = gbuilder.withName("Options").withOption((Option)inputOpt).withOption((Option)datasetOpt).withOption((Option)modelOpt).withOption((Option)outputOpt).withOption((Option)analyzeOpt).withOption((Option)mrOpt).withOption((Option)helpOpt).create();
        try {
            Parser parser = new Parser();
            parser.setGroup(group);
            CommandLine cmdLine = parser.parse(args);
            if (cmdLine.hasOption("help")) {
                CommandLineUtil.printHelp((Group)group);
                return -1;
            }
            String dataName = cmdLine.getValue((Option)inputOpt).toString();
            String datasetName = cmdLine.getValue((Option)datasetOpt).toString();
            String modelName = cmdLine.getValue((Option)modelOpt).toString();
            String outputName = cmdLine.hasOption((Option)outputOpt) ? cmdLine.getValue((Option)outputOpt).toString() : null;
            this.analyze = cmdLine.hasOption((Option)analyzeOpt);
            this.useMapreduce = cmdLine.hasOption((Option)mrOpt);
            log.debug("inout     : {}", (Object)dataName);
            log.debug("dataset   : {}", (Object)datasetName);
            log.debug("model     : {}", (Object)modelName);
            log.debug("output    : {}", (Object)outputName);
            log.debug("analyze   : {}", (Object)this.analyze);
            log.debug("mapreduce : {}", (Object)this.useMapreduce);
            this.dataPath = new Path(dataName);
            this.datasetPath = new Path(datasetName);
            this.modelPath = new Path(modelName);
            if (outputName != null) {
                this.outputPath = new Path(outputName);
            }
        }
        catch (OptionException e) {
            log.warn(e.toString(), (Throwable)e);
            CommandLineUtil.printHelp((Group)group);
            return -1;
        }
        this.testForest();
        return 0;
    }

    private void testForest() throws IOException, ClassNotFoundException, InterruptedException {
        FileSystem mfs;
        if (this.outputPath != null) {
            this.outFS = this.outputPath.getFileSystem(this.getConf());
            if (this.outFS.exists(this.outputPath)) {
                throw new IllegalArgumentException("Output path already exists");
            }
        }
        if (!(mfs = this.modelPath.getFileSystem(this.getConf())).exists(this.modelPath)) {
            throw new IllegalArgumentException("The forest path does not exist");
        }
        this.dataFS = this.dataPath.getFileSystem(this.getConf());
        if (!this.dataFS.exists(this.dataPath)) {
            throw new IllegalArgumentException("The Test data path does not exist");
        }
        if (this.useMapreduce) {
            this.mapreduce();
        } else {
            this.sequential();
        }
    }

    private void mapreduce() throws ClassNotFoundException, IOException, InterruptedException {
        if (this.outputPath == null) {
            throw new IllegalArgumentException("You must specify the ouputPath when using the mapreduce implementation");
        }
        Classifier classifier = new Classifier(this.modelPath, this.dataPath, this.datasetPath, this.outputPath, this.getConf(), this.analyze);
        classifier.run();
        if (this.analyze) {
            log.info("{}", (Object)classifier.getAnalyzer());
        }
    }

    private void sequential() throws IOException {
        ResultAnalyzer analyzer;
        log.info("Loading the forest...");
        DecisionForest forest = DecisionForest.load((Configuration)this.getConf(), (Path)this.modelPath);
        if (forest == null) {
            log.error("No Decision Forest found!");
            return;
        }
        Dataset dataset = Dataset.load((Configuration)this.getConf(), (Path)this.datasetPath);
        DataConverter converter = new DataConverter(dataset);
        log.info("Sequential classification...");
        long time = System.currentTimeMillis();
        Random rng = RandomUtils.getRandom();
        ResultAnalyzer resultAnalyzer = analyzer = this.analyze ? new ResultAnalyzer(Arrays.asList(dataset.labels()), "unknown") : null;
        if (this.dataFS.getFileStatus(this.dataPath).isDir()) {
            this.testDirectory(this.outputPath, converter, forest, dataset, analyzer, rng);
        } else {
            this.testFile(this.dataPath, this.outputPath, converter, forest, dataset, analyzer, rng);
        }
        time = System.currentTimeMillis() - time;
        log.info("Classification Time: {}", (Object)DFUtils.elapsedTime((long)time));
        if (analyzer != null) {
            log.info("{}", (Object)analyzer);
        }
    }

    private void testDirectory(Path outPath, DataConverter converter, DecisionForest forest, Dataset dataset, ResultAnalyzer analyzer, Random rng) throws IOException {
        Path[] infiles;
        for (Path path : infiles = DFUtils.listOutputFiles((FileSystem)this.dataFS, (Path)this.dataPath)) {
            log.info("Classifying : " + path);
            Path outfile = outPath != null ? new Path(outPath, path.getName()).suffix(".out") : null;
            this.testFile(path, outfile, converter, forest, dataset, analyzer, rng);
        }
    }

    private void testFile(Path inPath, Path outPath, DataConverter converter, DecisionForest forest, Dataset dataset, ResultAnalyzer analyzer, Random rng) throws IOException {
        FSDataOutputStream ofile = null;
        if (outPath != null) {
            ofile = this.outFS.create(outPath);
        }
        FSDataInputStream input = this.dataFS.open(inPath);
        Scanner scanner = new Scanner((InputStream)input);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (line.isEmpty()) continue;
            Instance instance = converter.convert(0, line);
            int prediction = forest.classify(rng, instance);
            if (this.outputPath != null) {
                ofile.writeChars(Integer.toString(prediction));
                ofile.writeChar(10);
            }
            if (analyzer == null) continue;
            analyzer.addInstance(dataset.getLabel(instance.getLabel()), new ClassifierResult(dataset.getLabel(prediction), 1.0));
        }
        scanner.close();
        input.close();
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Configuration)new Configuration(), (Tool)new TestForest(), (String[])args);
    }
}

