/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.df.mapreduce;

import java.io.IOException;
import java.util.Random;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.common.CommandLineUtil;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.df.DFUtils;
import org.apache.mahout.df.DecisionForest;
import org.apache.mahout.df.ErrorEstimate;
import org.apache.mahout.df.builder.DefaultTreeBuilder;
import org.apache.mahout.df.builder.TreeBuilder;
import org.apache.mahout.df.callback.ForestPredictions;
import org.apache.mahout.df.callback.PredictionCallback;
import org.apache.mahout.df.data.Data;
import org.apache.mahout.df.data.DataLoader;
import org.apache.mahout.df.data.Dataset;
import org.apache.mahout.df.mapreduce.inmem.InMemBuilder;
import org.apache.mahout.df.mapreduce.partial.PartialBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildForest
extends Configured
implements Tool {
    private static final Logger log = LoggerFactory.getLogger(BuildForest.class);
    private Path dataPath;
    private Path datasetPath;
    private Path outputPath;
    private int m;
    private int nbTrees;
    private Long seed;
    private boolean isPartial;
    private boolean isOob;

    public int run(String[] args) throws IOException, ClassNotFoundException, InterruptedException {
        DefaultOptionBuilder obuilder = new DefaultOptionBuilder();
        ArgumentBuilder abuilder = new ArgumentBuilder();
        GroupBuilder gbuilder = new GroupBuilder();
        DefaultOption oobOpt = obuilder.withShortName("oob").withRequired(false).withDescription("Optional, estimate the out-of-bag error").create();
        DefaultOption dataOpt = obuilder.withLongName("data").withShortName("d").withRequired(true).withArgument(abuilder.withName("path").withMinimum(1).withMaximum(1).create()).withDescription("Data path").create();
        DefaultOption datasetOpt = obuilder.withLongName("dataset").withShortName("ds").withRequired(true).withArgument(abuilder.withName("dataset").withMinimum(1).withMaximum(1).create()).withDescription("Dataset path").create();
        DefaultOption selectionOpt = obuilder.withLongName("selection").withShortName("sl").withRequired(true).withArgument(abuilder.withName("m").withMinimum(1).withMaximum(1).create()).withDescription("Number of variables to select randomly at each tree-node").create();
        DefaultOption seedOpt = obuilder.withLongName("seed").withShortName("sd").withRequired(false).withArgument(abuilder.withName("seed").withMinimum(1).withMaximum(1).create()).withDescription("Optional, seed value used to initialise the Random number generator").create();
        DefaultOption partialOpt = obuilder.withLongName("partial").withShortName("p").withRequired(false).withDescription("Optional, use the Partial Data implementation").create();
        DefaultOption nbtreesOpt = obuilder.withLongName("nbtrees").withShortName("t").withRequired(true).withArgument(abuilder.withName("nbtrees").withMinimum(1).withMaximum(1).create()).withDescription("Number of trees to grow").create();
        DefaultOption outputOpt = obuilder.withLongName("output").withShortName("o").withRequired(true).withArgument(abuilder.withName("path").withMinimum(1).withMaximum(1).create()).withDescription("Output path, will contain the Decision Forest").create();
        DefaultOption helpOpt = obuilder.withLongName("help").withDescription("Print out help").withShortName("h").create();
        Group group = gbuilder.withName("Options").withOption((Option)oobOpt).withOption((Option)dataOpt).withOption((Option)datasetOpt).withOption((Option)selectionOpt).withOption((Option)seedOpt).withOption((Option)partialOpt).withOption((Option)nbtreesOpt).withOption((Option)outputOpt).withOption((Option)helpOpt).create();
        try {
            Parser parser = new Parser();
            parser.setGroup(group);
            CommandLine cmdLine = parser.parse(args);
            if (cmdLine.hasOption("help")) {
                CommandLineUtil.printHelp((Group)group);
                return -1;
            }
            this.isPartial = cmdLine.hasOption((Option)partialOpt);
            this.isOob = cmdLine.hasOption((Option)oobOpt);
            String dataName = cmdLine.getValue((Option)dataOpt).toString();
            String datasetName = cmdLine.getValue((Option)datasetOpt).toString();
            String outputName = cmdLine.getValue((Option)outputOpt).toString();
            this.m = Integer.parseInt(cmdLine.getValue((Option)selectionOpt).toString());
            this.nbTrees = Integer.parseInt(cmdLine.getValue((Option)nbtreesOpt).toString());
            if (cmdLine.hasOption((Option)seedOpt)) {
                this.seed = Long.valueOf(cmdLine.getValue((Option)seedOpt).toString());
            }
            log.debug("data : {}", (Object)dataName);
            log.debug("dataset : {}", (Object)datasetName);
            log.debug("output : {}", (Object)outputName);
            log.debug("m : {}", (Object)this.m);
            log.debug("seed : {}", (Object)this.seed);
            log.debug("nbtrees : {}", (Object)this.nbTrees);
            log.debug("isPartial : {}", (Object)this.isPartial);
            log.debug("isOob : {}", (Object)this.isOob);
            this.dataPath = new Path(dataName);
            this.datasetPath = new Path(datasetName);
            this.outputPath = new Path(outputName);
        }
        catch (OptionException e) {
            log.error("Exception", (Throwable)e);
            CommandLineUtil.printHelp((Group)group);
            return -1;
        }
        this.buildForest();
        return 0;
    }

    private void buildForest() throws IOException, ClassNotFoundException, InterruptedException {
        PartialBuilder forestBuilder;
        ForestPredictions callback;
        FileSystem ofs = this.outputPath.getFileSystem(this.getConf());
        if (ofs.exists(this.outputPath)) {
            log.error("Output path already exists");
            return;
        }
        DefaultTreeBuilder treeBuilder = new DefaultTreeBuilder();
        treeBuilder.setM(this.m);
        Dataset dataset = Dataset.load((Configuration)this.getConf(), (Path)this.datasetPath);
        ForestPredictions forestPredictions = callback = this.isOob ? new ForestPredictions(dataset.nbInstances(), dataset.nblabels()) : null;
        if (this.isPartial) {
            log.info("Partial Mapred implementation");
            forestBuilder = new PartialBuilder((TreeBuilder)treeBuilder, this.dataPath, this.datasetPath, this.seed, this.getConf());
        } else {
            log.info("InMem Mapred implementation");
            forestBuilder = new InMemBuilder((TreeBuilder)treeBuilder, this.dataPath, this.datasetPath, this.seed, this.getConf());
        }
        forestBuilder.setOutputDirName(this.outputPath.getName());
        log.info("Building the forest...");
        long time = System.currentTimeMillis();
        DecisionForest forest = forestBuilder.build(this.nbTrees, (PredictionCallback)callback);
        time = System.currentTimeMillis() - time;
        log.info("Build Time: {}", (Object)DFUtils.elapsedTime((long)time));
        log.info("Forest num Nodes: {}", (Object)forest.nbNodes());
        log.info("Forest mean num Nodes: {}", (Object)forest.meanNbNodes());
        log.info("Forest mean max Depth: {}", (Object)forest.meanMaxDepth());
        if (this.isOob) {
            Random rng = this.seed != null ? RandomUtils.getRandom((long)this.seed) : RandomUtils.getRandom();
            FileSystem fs = this.dataPath.getFileSystem(this.getConf());
            int[] labels = Data.extractLabels((Dataset)dataset, (FileSystem)fs, (Path)this.dataPath);
            log.info("oob error estimate : " + ErrorEstimate.errorRate((int[])labels, (int[])callback.computePredictions(rng)));
        }
        Path forestPath = new Path(this.outputPath, "forest.seq");
        log.info("Storing the forest in: " + forestPath);
        DFUtils.storeWritable((Configuration)this.getConf(), (Path)forestPath, (Writable)forest);
    }

    protected static Data loadData(Configuration conf, Path dataPath, Dataset dataset) throws IOException {
        log.info("Loading the data...");
        FileSystem fs = dataPath.getFileSystem(conf);
        Data data = DataLoader.loadData((Dataset)dataset, (FileSystem)fs, (Path)dataPath);
        log.info("Data Loaded");
        return data;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Configuration)new Configuration(), (Tool)new BuildForest(), (String[])args);
    }
}

