/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.syntheticcontrol.meanshift;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.clustering.conversion.meanshift.InputDriver;
import org.apache.mahout.clustering.meanshift.MeanShiftCanopyDriver;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.distance.EuclideanDistanceMeasure;
import org.apache.mahout.utils.clustering.ClusterDumper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Job
extends AbstractJob {
    private static final Logger log = LoggerFactory.getLogger(Job.class);
    private static final String DIRECTORY_CONTAINING_CONVERTED_INPUT = "data";

    private Job() {
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            log.info("Running with only user-supplied arguments");
            ToolRunner.run((Configuration)new Configuration(), (Tool)new Job(), (String[])args);
        } else {
            log.info("Running with default arguments");
            Path output = new Path("output");
            Configuration conf = new Configuration();
            HadoopUtil.delete((Configuration)conf, (Path[])new Path[]{output});
            new Job().run(conf, new Path("testdata"), output, (DistanceMeasure)new EuclideanDistanceMeasure(), 47.6, 1.0, 0.5, 10);
        }
    }

    public int run(String[] args) throws IOException, ClassNotFoundException, InterruptedException, InstantiationException, IllegalAccessException {
        this.addInputOption();
        this.addOutputOption();
        this.addOption((Option)DefaultOptionCreator.convergenceOption().create());
        this.addOption((Option)DefaultOptionCreator.maxIterationsOption().create());
        this.addOption((Option)DefaultOptionCreator.overwriteOption().create());
        this.addOption((Option)new DefaultOptionBuilder().withLongName("inputIsCanopies").withRequired(false).withShortName("ic").withArgument(new ArgumentBuilder().withName("inputIsCanopies").withMinimum(1).withMaximum(1).create()).withDescription("If present, the input directory already contains MeanShiftCanopies").create());
        this.addOption((Option)DefaultOptionCreator.distanceMeasureOption().create());
        this.addOption((Option)DefaultOptionCreator.t1Option().create());
        this.addOption((Option)DefaultOptionCreator.t2Option().create());
        this.addOption((Option)DefaultOptionCreator.clusteringOption().create());
        Map argMap = this.parseArguments(args);
        if (argMap == null) {
            return -1;
        }
        Path input = this.getInputPath();
        Path output = this.getOutputPath();
        if (this.hasOption("overwrite")) {
            HadoopUtil.delete((Configuration)new Configuration(), (Path[])new Path[]{output});
        }
        String measureClass = this.getOption("distanceMeasure");
        double t1 = Double.parseDouble(this.getOption("t1"));
        double t2 = Double.parseDouble(this.getOption("t2"));
        double convergenceDelta = Double.parseDouble(this.getOption("convergenceDelta"));
        int maxIterations = Integer.parseInt(this.getOption("maxIter"));
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        DistanceMeasure measure = ccl.loadClass(measureClass).asSubclass(DistanceMeasure.class).newInstance();
        this.run(this.getConf(), input, output, measure, t1, t2, convergenceDelta, maxIterations);
        return 0;
    }

    public void run(Configuration conf, Path input, Path output, DistanceMeasure measure, double t1, double t2, double convergenceDelta, int maxIterations) throws IOException, InterruptedException, ClassNotFoundException {
        Path directoryContainingConvertedInput = new Path(output, DIRECTORY_CONTAINING_CONVERTED_INPUT);
        InputDriver.runJob((Path)input, (Path)directoryContainingConvertedInput);
        new MeanShiftCanopyDriver();
        MeanShiftCanopyDriver.run((Configuration)conf, (Path)directoryContainingConvertedInput, (Path)output, (DistanceMeasure)measure, (double)t1, (double)t2, (double)convergenceDelta, (int)maxIterations, (boolean)true, (boolean)true, (boolean)false);
        ClusterDumper clusterDumper = new ClusterDumper(new Path(output, "clusters-" + maxIterations), new Path(output, "clusteredPoints"));
        clusterDumper.printClusters(null);
    }
}

