/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.syntheticcontrol.kmeans;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.cli2.Option;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.clustering.canopy.CanopyDriver;
import org.apache.mahout.clustering.conversion.InputDriver;
import org.apache.mahout.clustering.kmeans.KMeansDriver;
import org.apache.mahout.clustering.kmeans.RandomSeedGenerator;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.distance.EuclideanDistanceMeasure;
import org.apache.mahout.common.distance.SquaredEuclideanDistanceMeasure;
import org.apache.mahout.utils.clustering.ClusterDumper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Job
extends AbstractJob {
    private static final Logger log = LoggerFactory.getLogger(Job.class);
    private static final String DIRECTORY_CONTAINING_CONVERTED_INPUT = "data";

    private Job() {
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            log.info("Running with only user-supplied arguments");
            ToolRunner.run((Configuration)new Configuration(), (Tool)new Job(), (String[])args);
        } else {
            log.info("Running with default arguments");
            Path output = new Path("output");
            Configuration conf = new Configuration();
            HadoopUtil.delete((Configuration)conf, (Path[])new Path[]{output});
            new Job().run(conf, new Path("testdata"), output, (DistanceMeasure)new EuclideanDistanceMeasure(), 6, 0.5, 10);
        }
    }

    public int run(String[] args) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, InterruptedException {
        this.addInputOption();
        this.addOutputOption();
        this.addOption((Option)DefaultOptionCreator.distanceMeasureOption().create());
        this.addOption((Option)DefaultOptionCreator.numClustersOption().create());
        this.addOption((Option)DefaultOptionCreator.t1Option().create());
        this.addOption((Option)DefaultOptionCreator.t2Option().create());
        this.addOption((Option)DefaultOptionCreator.convergenceOption().create());
        this.addOption((Option)DefaultOptionCreator.maxIterationsOption().create());
        this.addOption((Option)DefaultOptionCreator.overwriteOption().create());
        Map argMap = this.parseArguments(args);
        if (argMap == null) {
            return -1;
        }
        Path input = this.getInputPath();
        Path output = this.getOutputPath();
        String measureClass = this.getOption("distanceMeasure");
        if (measureClass == null) {
            measureClass = SquaredEuclideanDistanceMeasure.class.getName();
        }
        double convergenceDelta = Double.parseDouble(this.getOption("convergenceDelta"));
        int maxIterations = Integer.parseInt(this.getOption("maxIter"));
        if (this.hasOption("overwrite")) {
            HadoopUtil.delete((Configuration)this.getConf(), (Path[])new Path[]{output});
        }
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        Class<?> cl = ccl.loadClass(measureClass);
        DistanceMeasure measure = (DistanceMeasure)cl.newInstance();
        if (this.hasOption("numClusters")) {
            int k = Integer.parseInt(this.getOption("numClusters"));
            this.run(this.getConf(), input, output, measure, k, convergenceDelta, maxIterations);
        } else {
            double t1 = Double.parseDouble(this.getOption("t1"));
            double t2 = Double.parseDouble(this.getOption("t2"));
            this.run(this.getConf(), input, output, measure, t1, t2, convergenceDelta, maxIterations);
        }
        return 0;
    }

    public void run(Configuration conf, Path input, Path output, DistanceMeasure measure, int k, double convergenceDelta, int maxIterations) throws IOException, InterruptedException, ClassNotFoundException {
        Path directoryContainingConvertedInput = new Path(output, DIRECTORY_CONTAINING_CONVERTED_INPUT);
        log.info("Preparing Input");
        InputDriver.runJob((Path)input, (Path)directoryContainingConvertedInput, (String)"org.apache.mahout.math.RandomAccessSparseVector");
        log.info("Running random seed to get initial clusters");
        Path clusters = new Path(output, "clusters-0");
        clusters = RandomSeedGenerator.buildRandom((Configuration)conf, (Path)directoryContainingConvertedInput, (Path)clusters, (int)k, (DistanceMeasure)measure);
        log.info("Running KMeans");
        KMeansDriver.run((Configuration)conf, (Path)directoryContainingConvertedInput, (Path)clusters, (Path)output, (DistanceMeasure)measure, (double)convergenceDelta, (int)maxIterations, (boolean)true, (boolean)false);
        ClusterDumper clusterDumper = new ClusterDumper(Job.finalClusterPath(conf, output, maxIterations), new Path(output, "clusteredPoints"));
        clusterDumper.printClusters(null);
    }

    public void run(Configuration conf, Path input, Path output, DistanceMeasure measure, double t1, double t2, double convergenceDelta, int maxIterations) throws IOException, InterruptedException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Path directoryContainingConvertedInput = new Path(output, DIRECTORY_CONTAINING_CONVERTED_INPUT);
        log.info("Preparing Input");
        InputDriver.runJob((Path)input, (Path)directoryContainingConvertedInput, (String)"org.apache.mahout.math.RandomAccessSparseVector");
        log.info("Running Canopy to get initial clusters");
        CanopyDriver.run((Configuration)conf, (Path)directoryContainingConvertedInput, (Path)output, (DistanceMeasure)measure, (double)t1, (double)t2, (boolean)false, (boolean)false);
        log.info("Running KMeans");
        KMeansDriver.run((Configuration)conf, (Path)directoryContainingConvertedInput, (Path)new Path(output, "clusters-0"), (Path)output, (DistanceMeasure)measure, (double)convergenceDelta, (int)maxIterations, (boolean)true, (boolean)false);
        ClusterDumper clusterDumper = new ClusterDumper(Job.finalClusterPath(conf, output, maxIterations), new Path(output, "clusteredPoints"));
        clusterDumper.printClusters(null);
    }

    private static Path finalClusterPath(Configuration conf, Path output, int maxIterations) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        for (int i = maxIterations; i >= 0; --i) {
            Path clusters = new Path(output, "clusters-" + i);
            if (!fs.exists(clusters)) continue;
            return clusters;
        }
        return null;
    }
}

