/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.display;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.clustering.display.DisplayClustering;
import org.apache.mahout.clustering.spectral.kmeans.SpectralKMeansDriver;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.distance.ManhattanDistanceMeasure;
import org.apache.mahout.math.VectorWritable;

public class DisplaySpectralKMeans
extends DisplayClustering {
    DisplaySpectralKMeans() {
        this.initialize();
        this.setTitle("Spectral k-Means Clusters (>" + (int)(significance * 100.0) + "% of population)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ManhattanDistanceMeasure measure = new ManhattanDistanceMeasure();
        Path samples = new Path("samples");
        Path output = new Path("output");
        Configuration conf = new Configuration();
        HadoopUtil.delete((Configuration)conf, (Path[])new Path[]{samples});
        HadoopUtil.delete((Configuration)conf, (Path[])new Path[]{output});
        RandomUtils.useTestSeed();
        DisplayClustering.generateSamples();
        DisplaySpectralKMeans.writeSampleData(samples);
        Path affinities = new Path(output, "affinities");
        FileSystem fs = FileSystem.get((URI)output.toUri(), (Configuration)conf);
        if (!fs.exists(output)) {
            fs.mkdirs(output);
        }
        BufferedWriter writer = Files.newWriter((File)new File(affinities.toString()), (Charset)Charsets.UTF_8);
        try {
            for (int i = 0; i < SAMPLE_DATA.size(); ++i) {
                for (int j = 0; j < SAMPLE_DATA.size(); ++j) {
                    writer.write(i + "," + j + ',' + measure.distance(((VectorWritable)SAMPLE_DATA.get(i)).get(), ((VectorWritable)SAMPLE_DATA.get(j)).get()) + '\n');
                }
            }
        }
        finally {
            ((Writer)writer).close();
        }
        int maxIter = 10;
        double convergenceDelta = 0.001;
        SpectralKMeansDriver.run((Configuration)new Configuration(), (Path)affinities, (Path)output, (int)1100, (int)2, (DistanceMeasure)measure, (double)convergenceDelta, (int)maxIter);
        DisplaySpectralKMeans.loadClusters(output);
        new DisplaySpectralKMeans();
    }

    @Override
    public void paint(Graphics g) {
        DisplaySpectralKMeans.plotSampleData((Graphics2D)g);
        DisplaySpectralKMeans.plotClusters((Graphics2D)g);
    }
}

