/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.display;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.clustering.Cluster;
import org.apache.mahout.clustering.display.DisplayClustering;
import org.apache.mahout.clustering.meanshift.MeanShiftCanopy;
import org.apache.mahout.clustering.meanshift.MeanShiftCanopyDriver;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.distance.EuclideanDistanceMeasure;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisplayMeanShift
extends DisplayClustering {
    private static final Logger log = LoggerFactory.getLogger(DisplayMeanShift.class);
    private static double t1;
    private static double t2;

    private DisplayMeanShift() {
        this.initialize();
        this.setTitle("Mean Shift Canopy Clusters (>" + (int)(significance * 100.0) + "% of population)");
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        double sx = (double)res / 72.0;
        g2.setTransform(AffineTransform.getScaleInstance(sx, sx));
        g2.setColor(Color.BLACK);
        Vector dv = new DenseVector(2).assign(4.0);
        Vector dv1 = new DenseVector(2).assign(t1);
        Vector dv2 = new DenseVector(2).assign(t2);
        DisplayClustering.plotRectangle(g2, new DenseVector(2).assign(2.0), dv);
        DisplayClustering.plotRectangle(g2, new DenseVector(2).assign(-2.0), dv);
        g2.setColor(Color.DARK_GRAY);
        dv.assign(0.03);
        for (VectorWritable v : SAMPLE_DATA) {
            DisplayClustering.plotRectangle(g2, v.get(), dv);
        }
        int i = 0;
        for (Cluster cluster : (List)CLUSTERS.get(CLUSTERS.size() - 1)) {
            MeanShiftCanopy canopy = (MeanShiftCanopy)cluster;
            if (!((double)canopy.getBoundPoints().toList().size() >= significance * (double)DisplayClustering.SAMPLE_DATA.size())) continue;
            g2.setColor(COLORS[Math.min(i++, DisplayClustering.COLORS.length - 1)]);
            int count = 0;
            DenseVector center = new DenseVector(2);
            Iterator i$ = canopy.getBoundPoints().toList().iterator();
            while (i$.hasNext()) {
                int vix = (Integer)i$.next();
                Vector v = ((VectorWritable)SAMPLE_DATA.get(vix)).get();
                ++count;
                v.addTo((Vector)center);
                DisplayClustering.plotRectangle(g2, v, dv);
            }
            center = center.divide((double)count);
            DisplayClustering.plotEllipse(g2, (Vector)center, dv1);
            DisplayClustering.plotEllipse(g2, (Vector)center, dv2);
        }
    }

    public static void main(String[] args) throws Exception {
        t1 = 1.5;
        t2 = 0.5;
        EuclideanDistanceMeasure measure = new EuclideanDistanceMeasure();
        significance = 0.02;
        Path samples = new Path("samples");
        Path output = new Path("output");
        Configuration conf = new Configuration();
        HadoopUtil.delete((Configuration)conf, (Path[])new Path[]{samples});
        HadoopUtil.delete((Configuration)conf, (Path[])new Path[]{output});
        RandomUtils.useTestSeed();
        DisplayClustering.generateSamples();
        DisplayMeanShift.writeSampleData(samples);
        new MeanShiftCanopyDriver();
        MeanShiftCanopyDriver.run((Configuration)conf, (Path)samples, (Path)output, (DistanceMeasure)measure, (double)t1, (double)t2, (double)0.005, (int)20, (boolean)false, (boolean)true, (boolean)true);
        DisplayMeanShift.loadClusters(output);
        new DisplayMeanShift();
    }
}

