/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.display;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.clustering.ClusterClassifier;
import org.apache.mahout.clustering.ClusterIterator;
import org.apache.mahout.clustering.ClusteringPolicy;
import org.apache.mahout.clustering.KMeansClusteringPolicy;
import org.apache.mahout.clustering.display.DisplayClustering;
import org.apache.mahout.clustering.kmeans.Cluster;
import org.apache.mahout.clustering.kmeans.KMeansDriver;
import org.apache.mahout.clustering.kmeans.RandomSeedGenerator;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.distance.ManhattanDistanceMeasure;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class DisplayKMeans
extends DisplayClustering {
    DisplayKMeans() {
        this.initialize();
        this.setTitle("k-Means Clusters (>" + (int)(significance * 100.0) + "% of population)");
    }

    public static void main(String[] args) throws Exception {
        ManhattanDistanceMeasure measure = new ManhattanDistanceMeasure();
        Path samples = new Path("samples");
        Path output = new Path("output");
        Configuration conf = new Configuration();
        HadoopUtil.delete((Configuration)conf, (Path[])new Path[]{samples});
        HadoopUtil.delete((Configuration)conf, (Path[])new Path[]{output});
        RandomUtils.useTestSeed();
        DisplayClustering.generateSamples();
        DisplayKMeans.writeSampleData(samples);
        boolean runClusterer = false;
        if (runClusterer) {
            int numClusters = 3;
            DisplayKMeans.runSequentialKMeansClusterer(conf, samples, output, (DistanceMeasure)measure, numClusters);
        } else {
            int maxIterations = 10;
            DisplayKMeans.runSequentialKMeansClassifier(conf, samples, output, (DistanceMeasure)measure, maxIterations);
        }
        new DisplayKMeans();
    }

    private static void runSequentialKMeansClassifier(Configuration conf, Path samples, Path output, DistanceMeasure measure, int numClusters) throws IOException {
        ArrayList<Vector> points = new ArrayList<Vector>();
        for (int i = 0; i < numClusters; ++i) {
            points.add(((VectorWritable)SAMPLE_DATA.get(i)).get());
        }
        ArrayList<Cluster> initialClusters = new ArrayList<Cluster>();
        int id = 0;
        for (Vector point : points) {
            initialClusters.add(new Cluster(point, id++, measure));
        }
        ClusterClassifier prior = new ClusterClassifier(initialClusters);
        Path priorClassifier = new Path(output, "clusters-0");
        DisplayKMeans.writeClassifier(prior, conf, priorClassifier);
        int maxIter = 10;
        KMeansClusteringPolicy policy = new KMeansClusteringPolicy();
        new ClusterIterator((ClusteringPolicy)policy).iterate(samples, priorClassifier, output, maxIter);
        for (int i = 1; i <= maxIter; ++i) {
            ClusterClassifier posterior = DisplayKMeans.readClassifier(conf, new Path(output, "classifier-" + i));
            CLUSTERS.add(posterior.getModels());
        }
    }

    private static void runSequentialKMeansClusterer(Configuration conf, Path samples, Path output, DistanceMeasure measure, int maxIterations) throws IOException, InterruptedException, ClassNotFoundException {
        Path clusters = RandomSeedGenerator.buildRandom((Configuration)conf, (Path)samples, (Path)new Path(output, "clusters-0"), (int)3, (DistanceMeasure)measure);
        double distanceThreshold = 0.001;
        KMeansDriver.run((Path)samples, (Path)clusters, (Path)output, (DistanceMeasure)measure, (double)distanceThreshold, (int)maxIterations, (boolean)true, (boolean)true);
        DisplayKMeans.loadClusters(output);
    }

    @Override
    public void paint(Graphics g) {
        DisplayKMeans.plotSampleData((Graphics2D)g);
        DisplayKMeans.plotClusters((Graphics2D)g);
    }
}

