/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.display;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.clustering.ClusterClassifier;
import org.apache.mahout.clustering.ClusterIterator;
import org.apache.mahout.clustering.ClusteringPolicy;
import org.apache.mahout.clustering.FuzzyKMeansClusteringPolicy;
import org.apache.mahout.clustering.display.DisplayClustering;
import org.apache.mahout.clustering.fuzzykmeans.FuzzyKMeansDriver;
import org.apache.mahout.clustering.fuzzykmeans.SoftCluster;
import org.apache.mahout.clustering.kmeans.RandomSeedGenerator;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.distance.ManhattanDistanceMeasure;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class DisplayFuzzyKMeans
extends DisplayClustering {
    DisplayFuzzyKMeans() {
        this.initialize();
        this.setTitle("Fuzzy k-Means Clusters (>" + (int)(significance * 100.0) + "% of population)");
    }

    @Override
    public void paint(Graphics g) {
        DisplayFuzzyKMeans.plotSampleData((Graphics2D)g);
        DisplayFuzzyKMeans.plotClusters((Graphics2D)g);
    }

    public static void main(String[] args) throws Exception {
        ManhattanDistanceMeasure measure = new ManhattanDistanceMeasure();
        Path samples = new Path("samples");
        Path output = new Path("output");
        Configuration conf = new Configuration();
        HadoopUtil.delete((Configuration)conf, (Path[])new Path[]{samples});
        HadoopUtil.delete((Configuration)conf, (Path[])new Path[]{output});
        RandomUtils.useTestSeed();
        DisplayClustering.generateSamples();
        DisplayFuzzyKMeans.writeSampleData(samples);
        boolean runClusterer = false;
        int maxIterations = 10;
        if (runClusterer) {
            DisplayFuzzyKMeans.runSequentialFuzzyKClusterer(conf, samples, output, (DistanceMeasure)measure, maxIterations);
        } else {
            int numClusters = 3;
            DisplayFuzzyKMeans.runSequentialFuzzyKClassifier(conf, samples, output, (DistanceMeasure)measure, numClusters, maxIterations);
        }
        new DisplayFuzzyKMeans();
    }

    private static void runSequentialFuzzyKClassifier(Configuration conf, Path samples, Path output, DistanceMeasure measure, int numClusters, int maxIterations) throws IOException {
        ArrayList<Vector> points = new ArrayList<Vector>();
        for (int i = 0; i < numClusters; ++i) {
            points.add(((VectorWritable)SAMPLE_DATA.get(i)).get());
        }
        ArrayList<SoftCluster> initialClusters = new ArrayList<SoftCluster>();
        int id = 0;
        for (Vector point : points) {
            initialClusters.add(new SoftCluster(point, id++, measure));
        }
        ClusterClassifier prior = new ClusterClassifier(initialClusters);
        Path priorClassifier = new Path(output, "classifier-0");
        DisplayFuzzyKMeans.writeClassifier(prior, conf, priorClassifier);
        FuzzyKMeansClusteringPolicy policy = new FuzzyKMeansClusteringPolicy();
        new ClusterIterator((ClusteringPolicy)policy).iterate(samples, priorClassifier, output, maxIterations);
        for (int i = 1; i <= maxIterations; ++i) {
            ClusterClassifier posterior = DisplayFuzzyKMeans.readClassifier(conf, new Path(output, "classifier-" + i));
            CLUSTERS.add(posterior.getModels());
        }
    }

    private static void runSequentialFuzzyKClusterer(Configuration conf, Path samples, Path output, DistanceMeasure measure, int maxIterations) throws IOException, ClassNotFoundException, InterruptedException {
        Path clusters = RandomSeedGenerator.buildRandom((Configuration)conf, (Path)samples, (Path)new Path(output, "clusters-0"), (int)3, (DistanceMeasure)measure);
        double threshold = 0.001;
        int m = 3;
        FuzzyKMeansDriver.run((Path)samples, (Path)clusters, (Path)output, (DistanceMeasure)measure, (double)threshold, (int)maxIterations, (float)m, (boolean)true, (boolean)true, (double)threshold, (boolean)true);
        DisplayFuzzyKMeans.loadClusters(output);
    }
}

