/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.display;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.clustering.Cluster;
import org.apache.mahout.clustering.ClusterClassifier;
import org.apache.mahout.clustering.ClusterIterator;
import org.apache.mahout.clustering.ClusteringPolicy;
import org.apache.mahout.clustering.DirichletClusteringPolicy;
import org.apache.mahout.clustering.Model;
import org.apache.mahout.clustering.ModelDistribution;
import org.apache.mahout.clustering.dirichlet.DirichletClusterer;
import org.apache.mahout.clustering.dirichlet.models.GaussianClusterDistribution;
import org.apache.mahout.clustering.display.DisplayClustering;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisplayDirichlet
extends DisplayClustering {
    private static final Logger log = LoggerFactory.getLogger(DisplayDirichlet.class);

    public DisplayDirichlet() {
        this.initialize();
        this.setTitle("Dirichlet Process Clusters - Normal Distribution (>" + (int)(significance * 100.0) + "% of population)");
    }

    @Override
    public void paint(Graphics g) {
        DisplayDirichlet.plotSampleData((Graphics2D)g);
        DisplayDirichlet.plotClusters((Graphics2D)g);
    }

    protected static void printModels(Iterable<Cluster[]> result, int significant) {
        int row = 0;
        StringBuilder models = new StringBuilder(100);
        for (Cluster[] r : result) {
            models.append("sample[").append(row++).append("]= ");
            for (int k = 0; k < r.length; ++k) {
                Cluster model = r[k];
                if (model.count() <= (long)significant) continue;
                models.append('m').append(k).append(model.asFormatString(null)).append(", ");
            }
            models.append('\n');
        }
        models.append('\n');
        log.info(models.toString());
    }

    protected static void generateResults(ModelDistribution<VectorWritable> modelDist, int numClusters, int numIterations, double alpha0, int thin, int burnin) throws IOException {
        boolean runClusterer = false;
        if (runClusterer) {
            DisplayDirichlet.runSequentialDirichletClusterer(modelDist, numClusters, numIterations, alpha0, thin, burnin);
        } else {
            DisplayDirichlet.runSequentialDirichletClassifier(modelDist, numClusters, numIterations);
        }
    }

    private static void runSequentialDirichletClassifier(ModelDistribution<VectorWritable> modelDist, int numClusters, int numIterations) throws IOException {
        ArrayList<Cluster> models = new ArrayList<Cluster>();
        for (Model cluster : modelDist.sampleFromPrior(numClusters)) {
            models.add((Cluster)cluster);
        }
        ClusterClassifier prior = new ClusterClassifier(models);
        Path samples = new Path("samples");
        Path output = new Path("output");
        Path priorClassifier = new Path(output, "clusters-0");
        Configuration conf = new Configuration();
        DisplayDirichlet.writeClassifier(prior, conf, priorClassifier);
        DirichletClusteringPolicy policy = new DirichletClusteringPolicy(numClusters, (double)numIterations);
        new ClusterIterator((ClusteringPolicy)policy).iterate(samples, priorClassifier, output, numIterations);
        for (int i = 1; i <= numIterations; ++i) {
            ClusterClassifier posterior = DisplayDirichlet.readClassifier(conf, new Path(output, "classifier-" + i));
            ArrayList<Cluster> clusters = new ArrayList<Cluster>();
            for (Cluster cluster : posterior.getModels()) {
                if (!DisplayDirichlet.isSignificant(cluster)) continue;
                clusters.add(cluster);
            }
            CLUSTERS.add(clusters);
        }
    }

    private static void runSequentialDirichletClusterer(ModelDistribution<VectorWritable> modelDist, int numClusters, int numIterations, double alpha0, int thin, int burnin) {
        DirichletClusterer dc = new DirichletClusterer(SAMPLE_DATA, modelDist, alpha0, numClusters, thin, burnin);
        List result = dc.cluster(numIterations);
        DisplayDirichlet.printModels(result, burnin);
        for (Cluster[] models : result) {
            ArrayList<Cluster> clusters = new ArrayList<Cluster>();
            for (Cluster cluster : models) {
                if (!DisplayDirichlet.isSignificant(cluster)) continue;
                clusters.add(cluster);
            }
            CLUSTERS.add(clusters);
        }
    }

    public static void main(String[] args) throws Exception {
        VectorWritable modelPrototype = new VectorWritable((Vector)new DenseVector(2));
        GaussianClusterDistribution modelDist = new GaussianClusterDistribution(modelPrototype);
        RandomUtils.useTestSeed();
        DisplayDirichlet.generateSamples();
        int numIterations = 20;
        int numClusters = 10;
        boolean alpha0 = true;
        int thin = 3;
        int burnin = 5;
        DisplayDirichlet.generateResults((ModelDistribution<VectorWritable>)modelDist, numClusters, numIterations, (double)alpha0, thin, burnin);
        new DisplayDirichlet();
    }
}

