/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.bayes;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Locale;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DefaultStringifier;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.GenericsUtil;
import org.apache.lucene.analysis.Analyzer;
import org.apache.mahout.analysis.WikipediaAnalyzer;
import org.apache.mahout.classifier.bayes.WikipediaDatasetCreatorMapper;
import org.apache.mahout.classifier.bayes.WikipediaDatasetCreatorReducer;
import org.apache.mahout.classifier.bayes.XmlInputFormat;
import org.apache.mahout.common.CommandLineUtil;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.iterator.FileLineIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WikipediaDatasetCreatorDriver {
    private static final Logger log = LoggerFactory.getLogger(WikipediaDatasetCreatorDriver.class);

    private WikipediaDatasetCreatorDriver() {
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        DefaultOptionBuilder obuilder = new DefaultOptionBuilder();
        ArgumentBuilder abuilder = new ArgumentBuilder();
        GroupBuilder gbuilder = new GroupBuilder();
        DefaultOption dirInputPathOpt = obuilder.withLongName("input").withRequired(true).withArgument(abuilder.withName("input").withMinimum(1).withMaximum(1).create()).withDescription("The input directory path").withShortName("i").create();
        DefaultOption dirOutputPathOpt = obuilder.withLongName("output").withRequired(true).withArgument(abuilder.withName("output").withMinimum(1).withMaximum(1).create()).withDescription("The output directory Path").withShortName("o").create();
        DefaultOption categoriesOpt = obuilder.withLongName("categories").withRequired(true).withArgument(abuilder.withName("categories").withMinimum(1).withMaximum(1).create()).withDescription("Location of the categories file.  One entry per line. Will be used to make a string match in Wikipedia Category field").withShortName("c").create();
        DefaultOption exactMatchOpt = obuilder.withLongName("exactMatch").withDescription("If set, then the category name must exactly match the entry in the categories file. Default is false").withShortName("e").create();
        DefaultOption analyzerOpt = obuilder.withLongName("analyzer").withRequired(false).withArgument(abuilder.withName("analyzer").withMinimum(1).withMaximum(1).create()).withDescription("The analyzer to use, must have a no argument constructor").withShortName("a").create();
        DefaultOption helpOpt = obuilder.withLongName("help").withDescription("Print out help").withShortName("h").create();
        Group group = gbuilder.withName("Options").withOption((Option)categoriesOpt).withOption((Option)dirInputPathOpt).withOption((Option)dirOutputPathOpt).withOption((Option)exactMatchOpt).withOption((Option)analyzerOpt).withOption((Option)helpOpt).create();
        Parser parser = new Parser();
        parser.setGroup(group);
        try {
            CommandLine cmdLine = parser.parse(args);
            if (cmdLine.hasOption((Option)helpOpt)) {
                CommandLineUtil.printHelp((Group)group);
                return;
            }
            String inputPath = (String)cmdLine.getValue((Option)dirInputPathOpt);
            String outputPath = (String)cmdLine.getValue((Option)dirOutputPathOpt);
            String catFile = (String)cmdLine.getValue((Option)categoriesOpt);
            Class<WikipediaAnalyzer> analyzerClass = WikipediaAnalyzer.class;
            if (cmdLine.hasOption((Option)analyzerOpt)) {
                String className = cmdLine.getValue((Option)analyzerOpt).toString();
                analyzerClass = Class.forName(className).asSubclass(Analyzer.class);
                analyzerClass.newInstance();
            }
            WikipediaDatasetCreatorDriver.runJob(inputPath, outputPath, catFile, cmdLine.hasOption((Option)exactMatchOpt), analyzerClass);
        }
        catch (OptionException e) {
            log.error("Exception", (Throwable)e);
            CommandLineUtil.printHelp((Group)group);
        }
        catch (ClassNotFoundException e) {
            log.error("Exception", (Throwable)e);
            CommandLineUtil.printHelp((Group)group);
        }
        catch (InstantiationException e) {
            log.error("Exception", (Throwable)e);
            CommandLineUtil.printHelp((Group)group);
        }
        catch (IllegalAccessException e) {
            log.error("Exception", (Throwable)e);
            CommandLineUtil.printHelp((Group)group);
        }
    }

    public static void runJob(String input, String output, String catFile, boolean exactMatchOnly, Class<? extends Analyzer> analyzerClass) throws IOException, InterruptedException, ClassNotFoundException {
        Configuration conf = new Configuration();
        conf.set("key.value.separator.in.input.line", " ");
        conf.set("xmlinput.start", "<text xml:space=\"preserve\">");
        conf.set("xmlinput.end", "</text>");
        conf.setBoolean("exact.match.only", exactMatchOnly);
        conf.set("analyzer.class", analyzerClass.getName());
        conf.set("io.serializations", "org.apache.hadoop.io.serializer.JavaSerialization,org.apache.hadoop.io.serializer.WritableSerialization");
        HashSet<String> categories = new HashSet<String>();
        for (String line : new FileLineIterable(new File(catFile))) {
            categories.add(line.trim().toLowerCase(Locale.ENGLISH));
        }
        DefaultStringifier setStringifier = new DefaultStringifier(conf, GenericsUtil.getClass(categories));
        String categoriesStr = setStringifier.toString(categories);
        conf.set("wikipedia.categories", categoriesStr);
        Job job = new Job(conf);
        if (log.isInfoEnabled()) {
            log.info("Input: {} Out: {} Categories: {}", new Object[]{input, output, catFile});
        }
        job.setJarByClass(WikipediaDatasetCreatorDriver.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setMapperClass(WikipediaDatasetCreatorMapper.class);
        job.setInputFormatClass(XmlInputFormat.class);
        job.setReducerClass(WikipediaDatasetCreatorReducer.class);
        job.setOutputFormatClass(TextOutputFormat.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(input)});
        Path outPath = new Path(output);
        FileOutputFormat.setOutputPath((Job)job, (Path)outPath);
        HadoopUtil.delete((Configuration)conf, (Path[])new Path[]{outPath});
        job.waitForCompletion(true);
    }
}

