/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.bayes;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.BitSet;
import java.util.Random;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.common.CommandLineUtil;
import org.apache.mahout.common.IOUtils;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.apache.mahout.math.jet.random.sampling.RandomSampler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitBayesInput {
    private static final Logger log = LoggerFactory.getLogger(SplitBayesInput.class);
    private int testSplitSize = -1;
    private int testSplitPct = -1;
    private int splitLocation = 100;
    private int testRandomSelectionSize = -1;
    private int testRandomSelectionPct = -1;
    private Charset charset = Charsets.UTF_8;
    private final FileSystem fs;
    private Path inputDirectory;
    private Path trainingOutputDirectory;
    private Path testOutputDirectory;
    private SplitCallback callback;

    public static void main(String[] args) throws Exception {
        SplitBayesInput si = new SplitBayesInput();
        if (si.parseArgs(args)) {
            si.splitDirectory();
        }
    }

    public SplitBayesInput() throws IOException {
        Configuration conf = new Configuration();
        this.fs = FileSystem.get((Configuration)conf);
    }

    public boolean parseArgs(String[] args) throws Exception {
        DefaultOptionBuilder obuilder = new DefaultOptionBuilder();
        ArgumentBuilder abuilder = new ArgumentBuilder();
        GroupBuilder gbuilder = new GroupBuilder();
        Option helpOpt = DefaultOptionCreator.helpOption();
        DefaultOption inputDirOpt = obuilder.withLongName("inputDir").withRequired(true).withArgument(abuilder.withName("inputDir").withMinimum(1).withMaximum(1).create()).withDescription("The input directory").withShortName("i").create();
        DefaultOption trainingOutputDirOpt = obuilder.withLongName("trainingOutputDir").withRequired(true).withArgument(abuilder.withName("outputDir").withMinimum(1).withMaximum(1).create()).withDescription("The training data output directory").withShortName("tr").create();
        DefaultOption testOutputDirOpt = obuilder.withLongName("testOutputDir").withRequired(true).withArgument(abuilder.withName("outputDir").withMinimum(1).withMaximum(1).create()).withDescription("The test data output directory").withShortName("te").create();
        DefaultOption testSplitSizeOpt = obuilder.withLongName("testSplitSize").withRequired(false).withArgument(abuilder.withName("splitSize").withMinimum(1).withMaximum(1).create()).withDescription("The number of documents held back as test data for each category").withShortName("ss").create();
        DefaultOption testSplitPctOpt = obuilder.withLongName("testSplitPct").withRequired(false).withArgument(abuilder.withName("splitPct").withMinimum(1).withMaximum(1).create()).withDescription("The percentage of documents held back as test data for each category").withShortName("sp").create();
        DefaultOption splitLocationOpt = obuilder.withLongName("splitLocation").withRequired(false).withArgument(abuilder.withName("splitLoc").withMinimum(1).withMaximum(1).create()).withDescription("Location for start of test data expressed as a percentage of the input file size (0=start, 50=middle, 100=end").withShortName("sl").create();
        DefaultOption randomSelectionSizeOpt = obuilder.withLongName("randomSelectionSize").withRequired(false).withArgument(abuilder.withName("randomSize").withMinimum(1).withMaximum(1).create()).withDescription("The number of itemr to be randomly selected as test data ").withShortName("rs").create();
        DefaultOption randomSelectionPctOpt = obuilder.withLongName("randomSelectionPct").withRequired(false).withArgument(abuilder.withName("randomPct").withMinimum(1).withMaximum(1).create()).withDescription("Percentage of items to be randomly selected as test data ").withShortName("rp").create();
        DefaultOption charsetOpt = obuilder.withLongName("charset").withRequired(true).withArgument(abuilder.withName("charset").withMinimum(1).withMaximum(1).create()).withDescription("The name of the character encoding of the input files").withShortName("c").create();
        Group group = gbuilder.withName("Options").withOption((Option)inputDirOpt).withOption((Option)trainingOutputDirOpt).withOption((Option)testOutputDirOpt).withOption((Option)testSplitSizeOpt).withOption((Option)testSplitPctOpt).withOption((Option)splitLocationOpt).withOption((Option)randomSelectionSizeOpt).withOption((Option)randomSelectionPctOpt).withOption((Option)charsetOpt).create();
        try {
            Parser parser = new Parser();
            parser.setGroup(group);
            CommandLine cmdLine = parser.parse(args);
            if (cmdLine.hasOption(helpOpt)) {
                CommandLineUtil.printHelp((Group)group);
                return false;
            }
            this.inputDirectory = new Path((String)cmdLine.getValue((Option)inputDirOpt));
            this.trainingOutputDirectory = new Path((String)cmdLine.getValue((Option)trainingOutputDirOpt));
            this.testOutputDirectory = new Path((String)cmdLine.getValue((Option)testOutputDirOpt));
            this.charset = Charset.forName((String)cmdLine.getValue((Option)charsetOpt));
            if (cmdLine.hasOption((Option)testSplitSizeOpt) && cmdLine.hasOption((Option)testSplitPctOpt)) {
                throw new OptionException((Option)testSplitSizeOpt, "must have either split size or split percentage option, not BOTH");
            }
            if (!cmdLine.hasOption((Option)testSplitSizeOpt) && !cmdLine.hasOption((Option)testSplitPctOpt)) {
                throw new OptionException((Option)testSplitSizeOpt, "must have either split size or split percentage option");
            }
            if (cmdLine.hasOption((Option)testSplitSizeOpt)) {
                this.setTestSplitSize(Integer.parseInt((String)cmdLine.getValue((Option)testSplitSizeOpt)));
            }
            if (cmdLine.hasOption((Option)testSplitPctOpt)) {
                this.setTestSplitPct(Integer.parseInt((String)cmdLine.getValue((Option)testSplitPctOpt)));
            }
            if (cmdLine.hasOption((Option)splitLocationOpt)) {
                this.setSplitLocation(Integer.parseInt((String)cmdLine.getValue((Option)splitLocationOpt)));
            }
            if (cmdLine.hasOption((Option)randomSelectionSizeOpt)) {
                this.setTestRandomSelectionSize(Integer.parseInt((String)cmdLine.getValue((Option)randomSelectionSizeOpt)));
            }
            if (cmdLine.hasOption((Option)randomSelectionPctOpt)) {
                this.setTestRandomSelectionPct(Integer.parseInt((String)cmdLine.getValue((Option)randomSelectionPctOpt)));
            }
            this.fs.mkdirs(this.trainingOutputDirectory);
            this.fs.mkdirs(this.testOutputDirectory);
        }
        catch (OptionException e) {
            log.error("Command-line option Exception", (Throwable)e);
            CommandLineUtil.printHelp((Group)group);
            return false;
        }
        this.validate();
        return true;
    }

    public void splitDirectory() throws IOException {
        this.splitDirectory(this.inputDirectory);
    }

    public void splitDirectory(Path inputDir) throws IOException {
        FileStatus[] fileStats;
        if (this.fs.getFileStatus(inputDir) == null) {
            throw new IOException(inputDir + " does not exist");
        }
        if (!this.fs.getFileStatus(inputDir).isDir()) {
            throw new IOException(inputDir + " is not a directory");
        }
        for (FileStatus inputFile : fileStats = this.fs.listStatus(inputDir)) {
            if (inputFile.isDir()) continue;
            this.splitFile(inputFile.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void splitFile(Path inputFile) throws IOException {
        if (this.fs.getFileStatus(inputFile) == null) {
            throw new IOException(inputFile + " does not exist");
        }
        if (this.fs.getFileStatus(inputFile).isDir()) {
            throw new IOException(inputFile + " is a directory");
        }
        this.validate();
        Path testOutputFile = new Path(this.testOutputDirectory, inputFile.getName());
        Path trainingOutputFile = new Path(this.trainingOutputDirectory, inputFile.getName());
        int lineCount = SplitBayesInput.countLines(this.fs, inputFile, this.charset);
        log.info("{} has {} lines", (Object)inputFile.getName(), (Object)lineCount);
        int testSplitStart = 0;
        int testSplitSize = this.testSplitSize;
        BitSet randomSel = null;
        if (this.testRandomSelectionPct > 0 || this.testRandomSelectionSize > 0) {
            testSplitSize = this.testRandomSelectionSize;
            if (this.testRandomSelectionPct > 0) {
                testSplitSize = Math.round((float)(lineCount * this.testRandomSelectionPct) / 100.0f);
            }
            log.info("{} test split size is {} based on random selection percentage {}", new Object[]{inputFile.getName(), testSplitSize, this.testRandomSelectionPct});
            long[] ridx = new long[testSplitSize];
            RandomSampler.sample((long)testSplitSize, (long)(lineCount - 1), (int)testSplitSize, (long)0L, (long[])ridx, (int)0, (Random)RandomUtils.getRandom());
            randomSel = new BitSet(lineCount);
            for (long idx : ridx) {
                randomSel.set((int)idx + 1);
            }
        } else {
            if (this.testSplitPct > 0) {
                testSplitSize = Math.round((float)(lineCount * this.testSplitPct) / 100.0f);
                log.info("{} test split size is {} based on percentage {}", new Object[]{inputFile.getName(), testSplitSize, this.testSplitPct});
            } else {
                log.info("{} test split size is {}", (Object)inputFile.getName(), (Object)testSplitSize);
            }
            if (this.splitLocation > 0) {
                testSplitStart = Math.round((float)(lineCount * this.splitLocation) / 100.0f);
                if (lineCount - testSplitStart < testSplitSize) {
                    testSplitStart = lineCount - testSplitSize;
                }
                log.info("{} test split start is {} based on split location {}", new Object[]{inputFile.getName(), testSplitStart, this.splitLocation});
            }
            if (testSplitStart < 0) {
                throw new IllegalArgumentException("test split size for " + inputFile + " is too large, it would produce an " + "empty training set from the initial set of " + lineCount + " examples");
            }
            if (lineCount - testSplitSize < testSplitSize) {
                log.warn("Test set size for {} may be too large, {} is larger than the number of lines remaining in the training set: {}", new Object[]{inputFile, testSplitSize, lineCount - testSplitSize});
            }
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)this.fs.open(inputFile), this.charset));
        OutputStreamWriter trainingWriter = new OutputStreamWriter((OutputStream)this.fs.create(trainingOutputFile), this.charset);
        OutputStreamWriter testWriter = new OutputStreamWriter((OutputStream)this.fs.create(testOutputFile), this.charset);
        int trainCount = 0;
        int testCount = 0;
        try {
            String line;
            int pos = 0;
            while ((line = reader.readLine()) != null) {
                OutputStreamWriter writer;
                ++pos;
                if (this.testRandomSelectionPct > 0) {
                    writer = randomSel.get(pos) ? testWriter : trainingWriter;
                } else {
                    OutputStreamWriter outputStreamWriter = writer = pos > testSplitStart ? testWriter : trainingWriter;
                }
                if (writer == testWriter) {
                    if (testCount >= testSplitSize) {
                        writer = trainingWriter;
                    } else {
                        ++testCount;
                    }
                }
                if (writer == trainingWriter) {
                    ++trainCount;
                }
                writer.write(line);
                ((Writer)writer).write(10);
            }
        }
        catch (Throwable throwable) {
            IOUtils.quietClose((Closeable[])new Closeable[]{reader});
            IOUtils.quietClose((Closeable[])new Closeable[]{trainingWriter});
            IOUtils.quietClose((Closeable[])new Closeable[]{testWriter});
            throw throwable;
        }
        IOUtils.quietClose((Closeable[])new Closeable[]{reader});
        IOUtils.quietClose((Closeable[])new Closeable[]{trainingWriter});
        IOUtils.quietClose((Closeable[])new Closeable[]{testWriter});
        log.info("file: {}, input: {} train: {}, test: {} starting at {}", new Object[]{inputFile.getName(), lineCount, trainCount, testCount, testSplitStart});
        if (this.callback != null) {
            this.callback.splitComplete(inputFile, lineCount, trainCount, testCount, testSplitStart);
        }
    }

    public int getTestSplitSize() {
        return this.testSplitSize;
    }

    public void setTestSplitSize(int testSplitSize) {
        this.testSplitSize = testSplitSize;
    }

    public int getTestSplitPct() {
        return this.testSplitPct;
    }

    public void setTestSplitPct(int testSplitPct) {
        this.testSplitPct = testSplitPct;
    }

    public int getSplitLocation() {
        return this.splitLocation;
    }

    public void setSplitLocation(int splitLocation) {
        this.splitLocation = splitLocation;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public Path getInputDirectory() {
        return this.inputDirectory;
    }

    public void setInputDirectory(Path inputDir) {
        this.inputDirectory = inputDir;
    }

    public Path getTrainingOutputDirectory() {
        return this.trainingOutputDirectory;
    }

    public void setTrainingOutputDirectory(Path trainingOutputDir) {
        this.trainingOutputDirectory = trainingOutputDir;
    }

    public Path getTestOutputDirectory() {
        return this.testOutputDirectory;
    }

    public void setTestOutputDirectory(Path testOutputDir) {
        this.testOutputDirectory = testOutputDir;
    }

    public SplitCallback getCallback() {
        return this.callback;
    }

    public void setCallback(SplitCallback callback) {
        this.callback = callback;
    }

    public int getTestRandomSelectionSize() {
        return this.testRandomSelectionSize;
    }

    public void setTestRandomSelectionSize(int testRandomSelectionSize) {
        this.testRandomSelectionSize = testRandomSelectionSize;
    }

    public int getTestRandomSelectionPct() {
        return this.testRandomSelectionPct;
    }

    public void setTestRandomSelectionPct(int randomSelectionPct) {
        this.testRandomSelectionPct = randomSelectionPct;
    }

    public void validate() throws IOException {
        Preconditions.checkArgument((this.testSplitSize >= 1 || this.testSplitSize == -1 ? 1 : 0) != 0, (String)"Invalid testSplitSize", (Object[])new Object[]{this.testSplitSize});
        Preconditions.checkArgument((this.splitLocation >= 0 && this.splitLocation <= 100 || this.splitLocation == -1 ? 1 : 0) != 0, (String)"Invalid splitLocation percentage", (Object[])new Object[]{this.splitLocation});
        Preconditions.checkArgument((this.testSplitPct >= 0 && this.testSplitPct <= 100 || this.testSplitPct == -1 ? 1 : 0) != 0, (String)"Invalid testSplitPct percentage", (Object[])new Object[]{this.testSplitPct});
        Preconditions.checkArgument((this.splitLocation >= 0 && this.splitLocation <= 100 || this.splitLocation == -1 ? 1 : 0) != 0, (String)"Invalid splitLocation percentage", (Object[])new Object[]{this.splitLocation});
        Preconditions.checkArgument((this.testRandomSelectionPct >= 0 && this.testRandomSelectionPct <= 100 || this.testRandomSelectionPct == -1 ? 1 : 0) != 0, (String)"Invalid testRandomSelectionPct percentage", (Object[])new Object[]{this.testRandomSelectionPct});
        Preconditions.checkArgument((this.trainingOutputDirectory != null ? 1 : 0) != 0, (Object)"No training output directory was specified");
        Preconditions.checkArgument((this.testOutputDirectory != null ? 1 : 0) != 0, (Object)"No test output directory was specified");
        int count = 0;
        if (this.testSplitSize > 0) {
            ++count;
        }
        if (this.testSplitPct > 0) {
            ++count;
        }
        if (this.testRandomSelectionSize > 0) {
            ++count;
        }
        if (this.testRandomSelectionPct > 0) {
            ++count;
        }
        Preconditions.checkArgument((count == 1 ? 1 : 0) != 0, (Object)"Exactly one of testSplitSize, testSplitPct, testRandomSelectionSize, testRandomSelectionPct should be set");
        FileStatus trainingOutputDirStatus = this.fs.getFileStatus(this.trainingOutputDirectory);
        Preconditions.checkArgument((trainingOutputDirStatus != null && trainingOutputDirStatus.isDir() ? 1 : 0) != 0, (String)"%s is not a directory", (Object[])new Object[]{this.trainingOutputDirectory});
        FileStatus testOutputDirStatus = this.fs.getFileStatus(this.testOutputDirectory);
        Preconditions.checkArgument((testOutputDirStatus != null && testOutputDirStatus.isDir() ? 1 : 0) != 0, (String)"%s is not a directory", (Object[])new Object[]{this.testOutputDirectory});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int countLines(FileSystem fs, Path inputFile, Charset charset) throws IOException {
        int lineCount = 0;
        BufferedReader countReader = new BufferedReader(new InputStreamReader((InputStream)fs.open(inputFile), charset));
        try {
            while (countReader.readLine() != null) {
                ++lineCount;
            }
        }
        catch (Throwable throwable) {
            IOUtils.quietClose((Closeable[])new Closeable[]{countReader});
            throw throwable;
        }
        IOUtils.quietClose((Closeable[])new Closeable[]{countReader});
        return lineCount;
    }

    public static interface SplitCallback {
        public void splitComplete(Path var1, int var2, int var3, int var4, int var5);
    }
}

