/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.bayes;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.charset.Charset;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.util.Version;
import org.apache.mahout.classifier.BayesFileFormatter;
import org.apache.mahout.common.CommandLineUtil;
import org.apache.mahout.common.commandline.DefaultOptionCreator;

public final class PrepareTwentyNewsgroups {
    private PrepareTwentyNewsgroups() {
    }

    public static void main(String[] args) throws Exception {
        DefaultOptionBuilder obuilder = new DefaultOptionBuilder();
        ArgumentBuilder abuilder = new ArgumentBuilder();
        GroupBuilder gbuilder = new GroupBuilder();
        Option helpOpt = DefaultOptionCreator.helpOption();
        DefaultOption parentOpt = obuilder.withLongName("parent").withRequired(true).withArgument(abuilder.withName("parent").withMinimum(1).withMaximum(1).create()).withDescription("Parent dir containing the newsgroups").withShortName("p").create();
        DefaultOption outputDirOpt = obuilder.withLongName("outputDir").withRequired(true).withArgument(abuilder.withName("outputDir").withMinimum(1).withMaximum(1).create()).withDescription("The output directory").withShortName("o").create();
        DefaultOption analyzerNameOpt = obuilder.withLongName("analyzerName").withRequired(true).withArgument(abuilder.withName("analyzerName").withMinimum(1).withMaximum(1).create()).withDescription("The class name of the analyzer").withShortName("a").create();
        DefaultOption charsetOpt = obuilder.withLongName("charset").withRequired(true).withArgument(abuilder.withName("charset").withMinimum(1).withMaximum(1).create()).withDescription("The name of the character encoding of the input files").withShortName("c").create();
        Group group = gbuilder.withName("Options").withOption((Option)analyzerNameOpt).withOption((Option)charsetOpt).withOption((Option)outputDirOpt).withOption((Option)parentOpt).withOption(helpOpt).create();
        try {
            File[] categoryDirs;
            Analyzer analyzer;
            Parser parser = new Parser();
            parser.setGroup(group);
            CommandLine cmdLine = parser.parse(args);
            if (cmdLine.hasOption(helpOpt)) {
                CommandLineUtil.printHelp((Group)group);
                return;
            }
            File parentDir = new File((String)cmdLine.getValue((Option)parentOpt));
            File outputDir = new File((String)cmdLine.getValue((Option)outputDirOpt));
            String analyzerName = (String)cmdLine.getValue((Option)analyzerNameOpt);
            Charset charset = Charset.forName((String)cmdLine.getValue((Option)charsetOpt));
            try {
                analyzer = Class.forName(analyzerName).asSubclass(Analyzer.class).newInstance();
            }
            catch (InstantiationException e) {
                analyzer = (Analyzer)Class.forName(analyzerName).getConstructor(Version.class).newInstance(Version.LUCENE_30);
            }
            if (!parentDir.exists()) {
                throw new FileNotFoundException("Can't find input directory " + parentDir);
            }
            for (File dir : categoryDirs = parentDir.listFiles()) {
                if (!dir.isDirectory()) continue;
                if (!outputDir.exists() && !outputDir.mkdirs()) {
                    throw new IllegalStateException("Can't create output directory");
                }
                File outputFile = new File(outputDir, dir.getName() + ".txt");
                BayesFileFormatter.collapse((String)dir.getName(), (Analyzer)analyzer, (File)dir, (Charset)charset, (File)outputFile);
            }
        }
        catch (OptionException e) {
            CommandLineUtil.printHelp((Group)group);
        }
    }
}

