/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.example.netflix;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli2.OptionException;
import org.apache.mahout.cf.taste.example.TasteOptionParser;
import org.apache.mahout.cf.taste.impl.common.FastMap;
import org.apache.mahout.common.IOUtils;
import org.apache.mahout.common.iterator.FileLineIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransposeToByUser {
    private static final Logger log = LoggerFactory.getLogger(TransposeToByUser.class);

    private TransposeToByUser() {
    }

    public static void main(String[] args) throws IOException, OptionException {
        File dataDirectory = TasteOptionParser.getRatings(args);
        File byItemDirectory = new File(dataDirectory, "training_set");
        File byUserDirectory = new File(dataDirectory, "training_set_by_user");
        Preconditions.checkArgument((dataDirectory.exists() && dataDirectory.isDirectory() ? 1 : 0) != 0, (String)"%s is not a directory", (Object[])new Object[]{dataDirectory});
        Preconditions.checkArgument((byItemDirectory.exists() && byItemDirectory.isDirectory() ? 1 : 0) != 0, (String)"%s is not a directory", (Object[])new Object[]{byItemDirectory});
        Preconditions.checkArgument((!byUserDirectory.exists() ? 1 : 0) != 0, (String)"%s already exists", (Object[])new Object[]{byUserDirectory});
        byUserDirectory.mkdirs();
        FastMap byUserEntryCache = new FastMap(100000);
        for (File byItemFile : byItemDirectory.listFiles()) {
            log.info("Processing {}", (Object)byItemFile);
            Iterator lineIterator = new FileLineIterable(byItemFile, false).iterator();
            String line = (String)lineIterator.next();
            String movieIDString = line.substring(0, line.length() - 1);
            while (lineIterator.hasNext()) {
                line = (String)lineIterator.next();
                int firstComma = line.indexOf(44);
                String userIDString = line.substring(0, firstComma);
                int secondComma = line.indexOf(44, firstComma + 1);
                String ratingString = line.substring(firstComma, secondComma);
                ArrayList<String> cachedLines = (ArrayList<String>)byUserEntryCache.get(userIDString);
                if (cachedLines == null) {
                    cachedLines = new ArrayList<String>();
                    byUserEntryCache.put(userIDString, cachedLines);
                }
                cachedLines.add(movieIDString + ratingString);
                TransposeToByUser.maybeFlushCache(byUserDirectory, (Map<String, List<String>>)byUserEntryCache);
            }
        }
    }

    private static void maybeFlushCache(File byUserDirectory, Map<String, List<String>> byUserEntryCache) throws IOException {
        if (byUserEntryCache.size() >= 100000) {
            log.info("Flushing cache");
            for (Map.Entry<String, List<String>> entry : byUserEntryCache.entrySet()) {
                String userID = entry.getKey();
                List<String> lines = entry.getValue();
                int userIDValue = Integer.parseInt(userID);
                File intermediateDir = new File(byUserDirectory, String.valueOf(userIDValue % 10000));
                intermediateDir.mkdirs();
                File userIDFile = new File(intermediateDir, userIDValue / 10000 + ".txt");
                TransposeToByUser.appendStringsToFile(lines, userIDFile);
            }
            byUserEntryCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void appendStringsToFile(Iterable<String> strings, File file) throws IOException {
        PrintWriter outputStreamWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), Charsets.UTF_8));
        try {
            for (String s : strings) {
                outputStreamWriter.println(s);
            }
        }
        catch (Throwable throwable) {
            IOUtils.quietClose((Closeable[])new Closeable[]{outputStreamWriter});
            throw throwable;
        }
        IOUtils.quietClose((Closeable[])new Closeable[]{outputStreamWriter});
    }
}

