/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.example.netflix;

import java.io.File;
import java.io.IOException;
import org.apache.commons.cli2.OptionException;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.eval.RecommenderBuilder;
import org.apache.mahout.cf.taste.example.TasteOptionParser;
import org.apache.mahout.cf.taste.example.netflix.NetflixDataModel;
import org.apache.mahout.cf.taste.example.netflix.NetflixRecommenderBuilder;
import org.apache.mahout.cf.taste.impl.eval.AverageAbsoluteDifferenceRecommenderEvaluator;
import org.apache.mahout.cf.taste.model.DataModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetflixRecommenderEvaluatorRunner {
    private static final Logger log = LoggerFactory.getLogger(NetflixRecommenderEvaluatorRunner.class);

    private NetflixRecommenderEvaluatorRunner() {
    }

    public static void main(String ... args) throws IOException, TasteException, OptionException {
        AverageAbsoluteDifferenceRecommenderEvaluator evaluator = new AverageAbsoluteDifferenceRecommenderEvaluator();
        File ratingsFile = TasteOptionParser.getRatings(args);
        if (ratingsFile != null) {
            NetflixDataModel model = new NetflixDataModel(ratingsFile, true);
            double evaluation = evaluator.evaluate((RecommenderBuilder)new NetflixRecommenderBuilder(), null, (DataModel)model, 0.9, 0.1);
            log.info(String.valueOf(evaluation));
        } else {
            log.error("Netflix Recommender needs a ratings file to work. Please provide it with the -i command line option.");
        }
    }
}

