/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.example.netflix;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.NoSuchElementException;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.AbstractLongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.model.GenericItemPreferenceArray;
import org.apache.mahout.cf.taste.impl.model.GenericPreference;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.common.iterator.FileLineIterable;

public final class NetflixFileDataModel
implements DataModel {
    private final File dataDirectory;

    public NetflixFileDataModel(File dataDirectory) {
        Preconditions.checkArgument((dataDirectory != null && dataDirectory.exists() && dataDirectory.isDirectory() ? 1 : 0) != 0, (String)"%s is not a directory", (Object[])new Object[]{dataDirectory});
        this.dataDirectory = dataDirectory;
    }

    public LongPrimitiveIterator getUserIDs() {
        throw new UnsupportedOperationException();
    }

    public PreferenceArray getPreferencesFromUser(long id) {
        throw new UnsupportedOperationException();
    }

    public LongPrimitiveIterator getItemIDs() {
        return new MovieIDIterator();
    }

    public FastIDSet getItemIDsFromUser(long userID) {
        throw new UnsupportedOperationException();
    }

    public Float getPreferenceValue(long userID, long itemID) {
        throw new UnsupportedOperationException();
    }

    public Long getPreferenceTime(long userID, long itemID) {
        throw new UnsupportedOperationException();
    }

    public PreferenceArray getPreferencesForItem(long itemID) throws TasteException {
        StringBuilder itemIDPadded = new StringBuilder(5);
        itemIDPadded.append(itemID);
        while (itemIDPadded.length() < 5) {
            itemIDPadded.insert(0, '0');
        }
        ArrayList<GenericPreference> prefs = new ArrayList<GenericPreference>();
        File movieFile = new File(new File(this.dataDirectory, "training_set"), "mv_00" + itemIDPadded + ".txt");
        try {
            for (String line : new FileLineIterable(movieFile, true)) {
                int firstComma = line.indexOf(44);
                Integer userID = Integer.valueOf(line.substring(0, firstComma));
                int secondComma = line.indexOf(44, firstComma + 1);
                float rating = Float.parseFloat(line.substring(firstComma + 1, secondComma));
                prefs.add(new GenericPreference((long)userID.intValue(), itemID, rating));
            }
        }
        catch (IOException ioe) {
            throw new TasteException((Throwable)ioe);
        }
        return new GenericItemPreferenceArray(prefs);
    }

    public int getNumItems() {
        return 17770;
    }

    public int getNumUsers() {
        throw new UnsupportedOperationException();
    }

    public int getNumUsersWithPreferenceFor(long ... itemIDs) {
        throw new UnsupportedOperationException();
    }

    public void setPreference(long userID, long itemID, float value) {
        throw new UnsupportedOperationException();
    }

    public void removePreference(long userID, long itemID) {
        throw new UnsupportedOperationException();
    }

    public void refresh(Collection<Refreshable> alreadyRefreshed) {
    }

    public boolean hasPreferenceValues() {
        return true;
    }

    public float getMaxPreference() {
        return 0.0f;
    }

    public float getMinPreference() {
        return 0.0f;
    }

    public String toString() {
        return "NetflixFileDataModel";
    }

    private static final class MovieIDIterator
    extends AbstractLongPrimitiveIterator {
        static final int COUNT = 17770;
        private int next = 1;

        private MovieIDIterator() {
        }

        public long nextLong() {
            if (this.next <= 17770) {
                return this.next++;
            }
            throw new NoSuchElementException();
        }

        public long peek() {
            if (this.next <= 17770) {
                return this.next;
            }
            throw new NoSuchElementException();
        }

        public boolean hasNext() {
            return this.next <= 17770;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void skip(int n) {
            this.next += n;
        }
    }
}

