/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.example.netflix;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FastByIDMap;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.model.GenericDataModel;
import org.apache.mahout.cf.taste.impl.model.GenericPreference;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.common.iterator.FileLineIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetflixDataModel
implements DataModel {
    private static final Logger log = LoggerFactory.getLogger(NetflixDataModel.class);
    private final DataModel delegate;
    private final boolean useSubset;

    public NetflixDataModel(File dataDirectory, boolean useSubset) throws IOException {
        Preconditions.checkArgument((dataDirectory != null && dataDirectory.exists() && dataDirectory.isDirectory() ? 1 : 0) != 0, (String)"%s is not a directory", (Object[])new Object[]{dataDirectory});
        this.useSubset = useSubset;
        log.info("Creating NetflixDataModel for directory: {}", (Object)dataDirectory);
        log.info("Reading preference data...");
        FastByIDMap<PreferenceArray> users = this.readUsers(dataDirectory);
        log.info("Creating delegate DataModel...");
        this.delegate = new GenericDataModel(users);
    }

    private FastByIDMap<PreferenceArray> readUsers(File dataDirectory) throws IOException {
        FastByIDMap userIDPrefMap = new FastByIDMap();
        int counter = 0;
        MovieFilenameFilter filenameFilter = new MovieFilenameFilter();
        for (File movieFile : new File(dataDirectory, "training_set").listFiles(filenameFilter)) {
            Iterator lineIterator = new FileLineIterable(movieFile, false).iterator();
            String line = (String)lineIterator.next();
            long movieID = Long.parseLong(line.substring(0, line.length() - 1));
            while (lineIterator.hasNext()) {
                line = (String)lineIterator.next();
                if (++counter % 100000 == 0) {
                    log.info("Processed {} prefs", (Object)counter);
                }
                int firstComma = line.indexOf(44);
                long userID = Long.parseLong(line.substring(0, firstComma));
                int secondComma = line.indexOf(44, firstComma + 1);
                float rating = Float.parseFloat(line.substring(firstComma + 1, secondComma));
                ArrayList<GenericPreference> userPrefs = (ArrayList<GenericPreference>)userIDPrefMap.get(userID);
                if (userPrefs == null) {
                    userPrefs = new ArrayList<GenericPreference>(2);
                    userIDPrefMap.put(userID, userPrefs);
                }
                userPrefs.add(new GenericPreference(userID, movieID, rating));
            }
        }
        return GenericDataModel.toDataMap((FastByIDMap)userIDPrefMap, (boolean)true);
    }

    public LongPrimitiveIterator getUserIDs() throws TasteException {
        return this.delegate.getUserIDs();
    }

    public PreferenceArray getPreferencesFromUser(long id) throws TasteException {
        return this.delegate.getPreferencesFromUser(id);
    }

    public FastIDSet getItemIDsFromUser(long userID) throws TasteException {
        return this.delegate.getItemIDsFromUser(userID);
    }

    public LongPrimitiveIterator getItemIDs() throws TasteException {
        return this.delegate.getItemIDs();
    }

    public PreferenceArray getPreferencesForItem(long itemID) throws TasteException {
        return this.delegate.getPreferencesForItem(itemID);
    }

    public Float getPreferenceValue(long userID, long itemID) throws TasteException {
        return this.delegate.getPreferenceValue(userID, itemID);
    }

    public Long getPreferenceTime(long userID, long itemID) throws TasteException {
        return this.delegate.getPreferenceTime(userID, itemID);
    }

    public int getNumItems() throws TasteException {
        return this.delegate.getNumItems();
    }

    public int getNumUsers() throws TasteException {
        return this.delegate.getNumUsers();
    }

    public int getNumUsersWithPreferenceFor(long ... itemIDs) throws TasteException {
        return this.delegate.getNumUsersWithPreferenceFor(itemIDs);
    }

    public void setPreference(long userID, long itemID, float value) {
        throw new UnsupportedOperationException();
    }

    public void removePreference(long userID, long itemID) {
        throw new UnsupportedOperationException();
    }

    public void refresh(Collection<Refreshable> alreadyRefreshed) {
    }

    public boolean hasPreferenceValues() {
        return this.delegate.hasPreferenceValues();
    }

    public float getMaxPreference() {
        return this.delegate.getMaxPreference();
    }

    public float getMinPreference() {
        return this.delegate.getMinPreference();
    }

    public String toString() {
        return "NetflixDataModel";
    }

    private class MovieFilenameFilter
    implements FilenameFilter {
        private MovieFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String filename) {
            return filename.startsWith(NetflixDataModel.this.useSubset ? "mv_0000" : "mv_");
        }
    }
}

