/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.example.jester;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.mahout.cf.taste.example.grouplens.GroupLensDataModel;
import org.apache.mahout.cf.taste.impl.common.FastByIDMap;
import org.apache.mahout.cf.taste.impl.model.GenericDataModel;
import org.apache.mahout.cf.taste.impl.model.GenericPreference;
import org.apache.mahout.cf.taste.impl.model.file.FileDataModel;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.common.iterator.FileLineIterator;

public final class JesterDataModel
extends FileDataModel {
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    private long userBeingRead;

    public JesterDataModel() throws IOException {
        this(GroupLensDataModel.readResourceToTempFile("/org/apache/mahout/cf/taste/example/jester/jester-data-1.csv"));
    }

    public JesterDataModel(File ratingsFile) throws IOException {
        super(ratingsFile);
    }

    public void reload() {
        this.userBeingRead = 0L;
        super.reload();
    }

    protected DataModel buildModel() throws IOException {
        FastByIDMap data = new FastByIDMap();
        FileLineIterator iterator = new FileLineIterator(this.getDataFile(), false);
        FastByIDMap timestamps = new FastByIDMap();
        this.processFile(iterator, data, timestamps, false);
        return new GenericDataModel(GenericDataModel.toDataMap((FastByIDMap)data, (boolean)true));
    }

    protected void processLine(String line, FastByIDMap<?> rawData, FastByIDMap<FastByIDMap<Long>> timestamps, boolean fromPriorData) {
        FastByIDMap<?> data = rawData;
        String[] jokePrefs = COMMA_PATTERN.split(line);
        int count = Integer.parseInt(jokePrefs[0]);
        ArrayList<GenericPreference> prefs = new ArrayList<GenericPreference>(count);
        for (int itemID = 1; itemID < jokePrefs.length; ++itemID) {
            String jokePref = jokePrefs[itemID];
            if ("99".equals(jokePref)) continue;
            float jokePrefValue = Float.parseFloat(jokePref);
            prefs.add(new GenericPreference(this.userBeingRead, (long)itemID, jokePrefValue));
        }
        data.put(this.userBeingRead, prefs);
        ++this.userBeingRead;
    }
}

